% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_enable_domain_auto_renew}
\alias{route53domains_enable_domain_auto_renew}
\title{This operation configures Amazon Route 53 to automatically renew the
specified domain before the domain registration expires}
\usage{
route53domains_enable_domain_auto_renew(DomainName)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to enable automatic renewal for.}
}
\description{
This operation configures Amazon Route 53 to automatically renew the
specified domain before the domain registration expires. The cost of
renewing your domain registration is billed to your AWS account.
}
\details{
The period during which you can renew a domain name varies by TLD. For a
list of TLDs and their renewal policies, see \href{http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times}{"Renewal, restoration, and deletion times"}
on the website for our registrar associate, Gandi. Amazon Route 53
requires that you renew before the end of the renewal period that is
listed on the Gandi website so we can complete processing before the
deadline.
}
\section{Request syntax}{
\preformatted{svc$enable_domain_auto_renew(
  DomainName = "string"
)
}
}

\keyword{internal}
