% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_vpc_association_authorization}
\alias{route53_create_vpc_association_authorization}
\title{Authorizes the AWS account that created a specified VPC to submit an
AssociateVPCWithHostedZone request to associate the VPC with a specified
hosted zone that was created by a different account}
\usage{
route53_create_vpc_association_authorization(HostedZoneId, VPC)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the private hosted zone that you want to authorize associating
a VPC with.}

\item{VPC}{[required] A complex type that contains the VPC ID and region for the VPC that you
want to authorize associating with your hosted zone.}
}
\description{
Authorizes the AWS account that created a specified VPC to submit an
\code{AssociateVPCWithHostedZone} request to associate the VPC with a
specified hosted zone that was created by a different account. To submit
a \code{CreateVPCAssociationAuthorization} request, you must use the account
that created the hosted zone. After you authorize the association, use
the account that created the VPC to submit an
\code{AssociateVPCWithHostedZone} request.
}
\details{
If you want to associate multiple VPCs that you created by using one
account with a hosted zone that you created by using a different
account, you must submit one authorization request for each VPC.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_association_authorization(
  HostedZoneId = "string",
  VPC = list(
    VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1",
    VPCId = "string"
  )
)
}
}

\keyword{internal}
