# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Route 53 Domains
#'
#' @description
#' Amazon Route 53 API actions let you register domain names and perform
#' related operations.
#'
#' @examples
#' \donttest{svc <- route53domains()
#' svc$check_domain_availability(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=route53domains_check_domain_availability]{check_domain_availability} \tab This operation checks the availability of one domain name \cr
#'  \link[=route53domains_check_domain_transferability]{check_domain_transferability} \tab Checks whether a domain name can be transferred to Amazon Route 53 \cr
#'  \link[=route53domains_delete_tags_for_domain]{delete_tags_for_domain} \tab This operation deletes the specified tags for a domain \cr
#'  \link[=route53domains_disable_domain_auto_renew]{disable_domain_auto_renew} \tab This operation disables automatic renewal of domain registration for the specified domain \cr
#'  \link[=route53domains_disable_domain_transfer_lock]{disable_domain_transfer_lock} \tab This operation removes the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers \cr
#'  \link[=route53domains_enable_domain_auto_renew]{enable_domain_auto_renew} \tab This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires \cr
#'  \link[=route53domains_enable_domain_transfer_lock]{enable_domain_transfer_lock} \tab This operation sets the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers \cr
#'  \link[=route53domains_get_contact_reachability_status]{get_contact_reachability_status} \tab For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded \cr
#'  \link[=route53domains_get_domain_detail]{get_domain_detail} \tab This operation returns detailed information about a specified domain that is associated with the current AWS account \cr
#'  \link[=route53domains_get_domain_suggestions]{get_domain_suggestions} \tab The GetDomainSuggestions operation returns a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces) \cr
#'  \link[=route53domains_get_operation_detail]{get_operation_detail} \tab This operation returns the current status of an operation that is not completed \cr
#'  \link[=route53domains_list_domains]{list_domains} \tab This operation returns all the domain names registered with Amazon Route 53 for the current AWS account \cr
#'  \link[=route53domains_list_operations]{list_operations} \tab This operation returns the operation IDs of operations that are not yet complete \cr
#'  \link[=route53domains_list_tags_for_domain]{list_tags_for_domain} \tab This operation returns all of the tags that are associated with the specified domain \cr
#'  \link[=route53domains_register_domain]{register_domain} \tab This operation registers a domain \cr
#'  \link[=route53domains_renew_domain]{renew_domain} \tab This operation renews a domain for the specified number of years \cr
#'  \link[=route53domains_resend_contact_reachability_email]{resend_contact_reachability_email} \tab For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact\cr
#'  \link[=route53domains_retrieve_domain_auth_code]{retrieve_domain_auth_code} \tab This operation returns the AuthCode for the domain \cr
#'  \link[=route53domains_transfer_domain]{transfer_domain} \tab This operation transfers a domain from another registrar to Amazon Route 53 \cr
#'  \link[=route53domains_update_domain_contact]{update_domain_contact} \tab This operation updates the contact information for a particular domain \cr
#'  \link[=route53domains_update_domain_contact_privacy]{update_domain_contact_privacy} \tab This operation updates the specified domain contact's privacy setting \cr
#'  \link[=route53domains_update_domain_nameservers]{update_domain_nameservers} \tab This operation replaces the current set of name servers for the domain with the specified set of name servers \cr
#'  \link[=route53domains_update_tags_for_domain]{update_tags_for_domain} \tab This operation adds or updates tags for a specified domain \cr
#'  \link[=route53domains_view_billing]{view_billing} \tab Returns all the domain-related billing records for the current AWS account for a specified period 
#' }
#'
#' @rdname route53domains
#' @export
route53domains <- function() {
  .route53domains$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.route53domains <- list()

.route53domains$operations <- list()

.route53domains$metadata <- list(
  service_name = "route53domains",
  endpoints = list("*" = list(endpoint = "route53domains.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "route53domains.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Route 53 Domains",
  api_version = "2014-05-15",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "Route53Domains_v20140515"
)

.route53domains$handlers <- new_handlers("jsonrpc", "v4")

.route53domains$service <- function() {
  new_service(.route53domains$metadata, .route53domains$handlers)
}
