% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_endpoints}
\alias{route53resolver_list_resolver_endpoints}
\title{Lists all the Resolver endpoints that were created using the current AWS
account}
\usage{
route53resolver_list_resolver_endpoints(MaxResults, NextToken, Filters)
}
\arguments{
\item{MaxResults}{The maximum number of Resolver endpoints that you want to return in the
response to a
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request. If you don't specify a value for \code{MaxResults}, Resolver returns
up to 100 Resolver endpoints.}

\item{NextToken}{For the first
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request, omit this value.

If you have more than \code{MaxResults} Resolver endpoints, you can submit
another
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request to get the next group of Resolver endpoints. In the next
request, specify the value of \code{NextToken} from the previous response.}

\item{Filters}{An optional specification to return a subset of Resolver endpoints, such
as all inbound Resolver endpoints.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints}}
request and specify the \code{NextToken} parameter, you must use the same
values for \code{Filters}, if any, as in the previous request.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  MaxResults = 123,
  ResolverEndpoints = list(
    list(
      Id = "string",
      CreatorRequestId = "string",
      Arn = "string",
      Name = "string",
      SecurityGroupIds = list(
        "string"
      ),
      Direction = "INBOUND"|"OUTBOUND",
      IpAddressCount = 123,
      HostVPCId = "string",
      Status = "CREATING"|"OPERATIONAL"|"UPDATING"|"AUTO_RECOVERING"|"ACTION_NEEDED"|"DELETING",
      StatusMessage = "string",
      CreationTime = "string",
      ModificationTime = "string"
    )
  )
)
}
}
\description{
Lists all the Resolver endpoints that were created using the current AWS
account.
}
\section{Request syntax}{
\preformatted{svc$list_resolver_endpoints(
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
