% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_loa}
\alias{directconnect_describe_loa}
\title{Gets the LOA-CFA for a connection, interconnect, or link aggregation
group (LAG)}
\usage{
directconnect_describe_loa(connectionId, providerName, loaContentType)
}
\arguments{
\item{connectionId}{[required] The ID of a connection, LAG, or interconnect.}

\item{providerName}{The name of the service provider who establishes connectivity on your
behalf. If you specify this parameter, the LOA-CFA lists the provider
name alongside your company name as the requester of the cross connect.}

\item{loaContentType}{The standard media type for the LOA-CFA document. The only supported
value is application/pdf.}
}
\value{
A list with the following syntax:\preformatted{list(
  loaContent = raw,
  loaContentType = "application/pdf"
)
}
}
\description{
Gets the LOA-CFA for a connection, interconnect, or link aggregation
group (LAG).

The Letter of Authorization - Connecting Facility Assignment (LOA-CFA)
is a document that is used when establishing your cross connect to AWS
at the colocation facility. For more information, see \href{https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html}{Requesting Cross Connects at AWS Direct Connect Locations}
in the \emph{AWS Direct Connect User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_loa(
  connectionId = "string",
  providerName = "string",
  loaContentType = "application/pdf"
)
}
}

\keyword{internal}
