% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimblestudio_service.R
\name{nimblestudio}
\alias{nimblestudio}
\title{AmazonNimbleStudio}
\usage{
nimblestudio(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Welcome to the Amazon Nimble Studio API reference. This API reference
provides methods, schema, resources, parameters, and more to help you
get the most out of Nimble Studio.

Nimble Studio is a virtual studio that empowers visual effects,
animation, and interactive content teams to create content securely
within a scalable, private cloud service.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- nimblestudio(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=nimblestudio_accept_eulas]{accept_eulas} \tab Accept EULAs\cr
\link[=nimblestudio_create_launch_profile]{create_launch_profile} \tab Create a launch profile\cr
\link[=nimblestudio_create_streaming_image]{create_streaming_image} \tab Creates a streaming image resource in a studio\cr
\link[=nimblestudio_create_streaming_session]{create_streaming_session} \tab Creates a streaming session in a studio\cr
\link[=nimblestudio_create_streaming_session_stream]{create_streaming_session_stream} \tab Creates a streaming session stream for a streaming session\cr
\link[=nimblestudio_create_studio]{create_studio} \tab Create a new Studio\cr
\link[=nimblestudio_create_studio_component]{create_studio_component} \tab Creates a studio component resource\cr
\link[=nimblestudio_delete_launch_profile]{delete_launch_profile} \tab Permanently delete a launch profile\cr
\link[=nimblestudio_delete_launch_profile_member]{delete_launch_profile_member} \tab Delete a user from launch profile membership\cr
\link[=nimblestudio_delete_streaming_image]{delete_streaming_image} \tab Delete streaming image\cr
\link[=nimblestudio_delete_streaming_session]{delete_streaming_session} \tab Deletes streaming session resource\cr
\link[=nimblestudio_delete_studio]{delete_studio} \tab Delete a studio resource\cr
\link[=nimblestudio_delete_studio_component]{delete_studio_component} \tab Deletes a studio component resource\cr
\link[=nimblestudio_delete_studio_member]{delete_studio_member} \tab Delete a user from studio membership\cr
\link[=nimblestudio_get_eula]{get_eula} \tab Get Eula\cr
\link[=nimblestudio_get_launch_profile]{get_launch_profile} \tab Get a launch profile\cr
\link[=nimblestudio_get_launch_profile_details]{get_launch_profile_details} \tab Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile\cr
\link[=nimblestudio_get_launch_profile_initialization]{get_launch_profile_initialization} \tab Get a launch profile initialization\cr
\link[=nimblestudio_get_launch_profile_member]{get_launch_profile_member} \tab Get a user persona in launch profile membership\cr
\link[=nimblestudio_get_streaming_image]{get_streaming_image} \tab Get streaming image\cr
\link[=nimblestudio_get_streaming_session]{get_streaming_session} \tab Gets StreamingSession resource\cr
\link[=nimblestudio_get_streaming_session_stream]{get_streaming_session_stream} \tab Gets a StreamingSessionStream for a streaming session\cr
\link[=nimblestudio_get_studio]{get_studio} \tab Get a Studio resource\cr
\link[=nimblestudio_get_studio_component]{get_studio_component} \tab Gets a studio component resource\cr
\link[=nimblestudio_get_studio_member]{get_studio_member} \tab Get a user's membership in a studio\cr
\link[=nimblestudio_list_eula_acceptances]{list_eula_acceptances} \tab List Eula Acceptances\cr
\link[=nimblestudio_list_eulas]{list_eulas} \tab List Eulas\cr
\link[=nimblestudio_list_launch_profile_members]{list_launch_profile_members} \tab Get all users in a given launch profile membership\cr
\link[=nimblestudio_list_launch_profiles]{list_launch_profiles} \tab List all the launch profiles a studio\cr
\link[=nimblestudio_list_streaming_images]{list_streaming_images} \tab List the streaming image resources available to this studio\cr
\link[=nimblestudio_list_streaming_sessions]{list_streaming_sessions} \tab Lists the streaming sessions in a studio\cr
\link[=nimblestudio_list_studio_components]{list_studio_components} \tab Lists the StudioComponents in a studio\cr
\link[=nimblestudio_list_studio_members]{list_studio_members} \tab Get all users in a given studio membership\cr
\link[=nimblestudio_list_studios]{list_studios} \tab List studios in your Amazon Web Services account in the requested Amazon Web Services Region\cr
\link[=nimblestudio_list_tags_for_resource]{list_tags_for_resource} \tab Gets the tags for a resource, given its Amazon Resource Names (ARN)\cr
\link[=nimblestudio_put_launch_profile_members]{put_launch_profile_members} \tab Add/update users with given persona to launch profile membership\cr
\link[=nimblestudio_put_studio_members]{put_studio_members} \tab Add/update users with given persona to studio membership\cr
\link[=nimblestudio_start_streaming_session]{start_streaming_session} \tab Transitions sessions from the STOPPED state into the READY state\cr
\link[=nimblestudio_start_studio_sso_configuration_repair]{start_studio_sso_configuration_repair} \tab Repairs the Amazon Web Services SSO configuration for a given studio\cr
\link[=nimblestudio_stop_streaming_session]{stop_streaming_session} \tab Transitions sessions from the READY state into the STOPPED state\cr
\link[=nimblestudio_tag_resource]{tag_resource} \tab Creates tags for a resource, given its ARN\cr
\link[=nimblestudio_untag_resource]{untag_resource} \tab Deletes the tags for a resource\cr
\link[=nimblestudio_update_launch_profile]{update_launch_profile} \tab Update a launch profile\cr
\link[=nimblestudio_update_launch_profile_member]{update_launch_profile_member} \tab Update a user persona in launch profile membership\cr
\link[=nimblestudio_update_streaming_image]{update_streaming_image} \tab Update streaming image\cr
\link[=nimblestudio_update_studio]{update_studio} \tab Update a Studio resource\cr
\link[=nimblestudio_update_studio_component]{update_studio_component} \tab Updates a studio component resource
}
}

\examples{
\dontrun{
svc <- nimblestudio()
svc$accept_eulas(
  Foo = 123
)
}

}
