% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{subjectProfileReportFormat}
\alias{subjectProfileReportFormat}
\title{Get list with format specification for subject profile report.}
\usage{
subjectProfileReportFormat(
  heightLineIn = 0.2,
  margin = 0.75,
  landscape = FALSE,
  aspectRatio = 0.5,
  yLabelWidth = 30
)
}
\arguments{
\item{heightLineIn}{Numeric of length 1 with 
height of a line in inches, 0.2 by default.}

\item{margin}{Numeric of length 1, with margin in inches.}

\item{landscape}{Logical, if TRUE the created report is 
in landscape format. FALSE by default, the report
is created in portrait format.}

\item{aspectRatio}{Numeric of length 1 (0.75 by default)
with ratio between size of image in inches 
(derived from specified \code{margin}, \code{landscape} and \code{heightLineIn})
and real size for exported image.}

\item{yLabelWidth}{Integer of length 1 with approximate maximum number of
characters in the y-label of the plot, 30 by default.
If the label of the y-axis is longer than this number 
of character, it will be splitted between words 
in separated lines.}
}
\value{
List with parameters to set format
of the subject profile report.
If not specified, default are used.
}
\description{
This format is used to set default for the created subject profile report:
line height, margin, report in landscape or portrait format,
aspect ratio and width for the y-label.
}
\author{
Laure Cougnaud
}
