% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotROC}
\alias{plotROC}
\title{plot the ROC curve}
\usage{
plotROC(
  riskscore,
  response,
  main,
  add = FALSE,
  col = par("col"),
  legacy.axes = TRUE,
  print.auc = FALSE,
  grid = FALSE,
  auc.polygon = FALSE,
  auc.polygon.col = "skyblue",
  max.auc.polygon = FALSE,
  max.auc.polygon.col = "#EEEEEE"
)
}
\arguments{
\item{riskscore}{a numeric vector of the same length than response, containing the predicted value of each observation.}

\item{response}{a factor, numeric or character vector of responses (true class), typically encoded with 0 (controls) and 1 (cases). Only two classes can be used in a ROC curve.}

\item{main}{the title of the ROC curve}

\item{add}{if TRUE, the ROC curve will be added to an existing plot. If FALSE (default), a new plot will be created.}

\item{col}{the color of the ROC curve}

\item{legacy.axes}{a logical indicating if the specificity axis (x axis) must be plotted as as decreasing “specificity” (FALSE) or increasing “1 - specificity” (TRUE, the default) as in most legacy software. This affects only the axis, not the plot coordinates.}

\item{print.auc}{boolean. Should the numeric value of AUC be printed on the plot?}

\item{grid}{boolean or numeric vector of length 1 or 2. Should a background grid be added to the plot? Numeric: show a grid with the specified interval between each line; Logical: show the grid or not. Length 1: same values are taken for horizontal and vertical lines. Length 2: grid value for vertical (grid[1]) and horizontal (grid[2]). Note that these values are used to compute grid.v and grid.h. Therefore if you specify a grid.h and grid.v, it will be ignored.}

\item{auc.polygon}{boolean. Whether or not to display the area as a polygon.}

\item{auc.polygon.col}{color (col) for the AUC polygon.}

\item{max.auc.polygon}{boolean. Whether or not to display the maximal possible area as a polygon.}

\item{max.auc.polygon.col}{color (col) for the maximum AUC polygon.}
}
\value{
No return value
}
\description{
This function uses to plot a ROC curve.
}
\examples{
#get the path of the mutation annotation file and samples' survival data
maf<-system.file("extdata","data_mutations_extended.txt",package = "pathwayTMB")
sur_path<-system.file("extdata","sur.csv",package = "pathwayTMB")
sur<-read.csv(sur_path,header=TRUE,row.names = 1)
#perform the function 'get_mut_matrix'
\donttest{mut_matrix<-get_mut_matrix(maffile=maf,mut_fre = 0.01,is.TCGA=FALSE,sur=sur)
#perform the function `get_PTMB`
PTMB_matrix<-get_PTMB(freq_matrix=mut_matrix,genesmbol=genesmbol,gene_path=gene_path)
set.seed(1)
final_character<-get_final_signature(PTMB=PTMB_matrix,sur=sur)}
#calculate the risksciore
riskscore<-plotKMcurves(t(PTMB_matrix[final_character,]),sur=sur,plots=FALSE)$risk_score
#get the path of samples' immunotherapy response data
res_path<- system.file("extdata","response.csv",package = "pathwayTMB")
response<-read.csv(res_path,header=TRUE,stringsAsFactors =FALSE,row.name=1)
plotROC(riskscore=riskscore,response=response,main="Objective Response",print.auc=TRUE)

}
