% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_manova.R
\name{coefficient_manova}
\alias{coefficient_manova}
\title{Compare coefficient vectors using MANOVA.}
\usage{
coefficient_manova(model_list)
}
\arguments{
\item{model_list}{A list of regression models.}
}
\value{
Numeric vector of MANOVA test results. This includes Wilk's lambda,
 MANOVA F-statistic, numerator degrees of freedom, denominator degrees of
 freedom, and the associated p-value.
}
\description{
Compare coefficient vectors using MANOVA across multiple models.
}
\details{
Removes intercept from each coefficient vector, then performs a MANOVA
analysis to compare remaining regression coefficients across models.
Specifically, for models with matrix notation

\deqn{\mathbf{Y}_m = \beta_{m0} + \mathbf{X}_m \mathbf{B}_m}{Ym = bm0 + Xm Bm}

for \eqn{i = 1, 2, ..., M}, test the null hypothesis

\deqn{\mathbf{B}_1 = \mathbf{B}_2 = ... = \mathbf{B}_m}{B1 = B2 = ... = Bm}

against the alternative hypothesis that not all coefficient vectors are equal.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 coefficient_manova(model_list = mList)

}
