% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelPomp.R
\docType{class}
\name{panelPomp}
\alias{panelPomp}
\alias{panelPomp-class}
\title{Constructing \code{panelPomp} objects}
\usage{
panelPomp(object, shared, specific, params)
}
\arguments{
\item{object}{required; either (i) a \code{list} of \code{pomp} objects; or
(ii) an object of class \code{panelPomp} or inheriting class
\code{panelPomp}.

If \code{object} is a \code{list} of \code{pomp}s, the list must be named.
All these \code{pomp}s must either have no parameters or have the same
parameter names. (This is just a format requirement. \code{pomp} codes can
ignore any parameter that is irrelevant to any given panel unit.)

If \code{object} is a \code{panelPomp} object, the function allows modifying
the shared and unit-specific configuration of \code{object}.}

\item{shared, specific}{optional; these arguments depend on the type
of \code{object}.

If \code{object} is a \code{list} of \code{pomp}s, \code{shared} must be a
numeric vector specifying parameter values shared among panel units.
\code{specific} must be a \code{matrix} with parameter values that are
unit-specific with rows naming parameters and columns naming units (these
names must match those of \code{object}). If no values are specified and
\code{object} has parameter values, these are set to be all unit-specific.

If \code{object} is a \code{panelPomp} object, these arguments can still be
used as described above to modify the parameters of \code{object}.
Alternatively, the parameter configuration of \code{object} can be modified
providing only a character \code{shared} naming parameters of \code{object}
that should be shared (with values for parameters not originally shared
taken from the unit-specific parameters of the first panel unit of
\code{object}). \code{shared=NULL} sets all parameters as unit-specific.}

\item{params}{optional; a named numeric vector. In this case, the nature of
parameters is determined via a naming convention: names ending in
\dQuote{\code{[unit_name]}} are assumed to denote unit-specific parameters;
all other names specify shared parameters.}
}
\value{
A \code{panelPomp} object.
}
\description{
This function constructs \code{panelPomp} objects, representing
PanelPOMP models (as defined in \Breto et al., 2020). PanelPOMP models
involve multiple units, each of which can in turn be modeled by a POMP
model. Such POMP models can be encoded as a \code{list} of \code{pomp}
objects, a cornerstone that the \code{panelPomp} function can use to
construct the corresponding \code{panelPomp} object.
}
\examples{
## recreate the 'panelRandomWalk()' example
prw <- panelRandomWalk()
prw2 <- panelPomp(unit_objects(prw), params = coef(prw))
identical(prw, prw2) # TRUE
}
\references{
\breto2020

\king2016
}
\seealso{
\pkg{pomp}'s constructor at \link[pomp]{pomp}

Other panelPomp workhorse functions: 
\code{\link{mif2}()},
\code{\link{panel_loglik}},
\code{\link{pfilter}()}
}
\author{
Carles \Breto
}
\concept{panelPomp workhorse functions}
