% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_span.R
\name{subset_span}
\alias{subset_span}
\title{Subset a spanned datetime vector}
\usage{
subset_span(spanned, pattern_list)
}
\arguments{
\item{spanned}{A vector of class  \code{Date}, \code{POSIXct}, or
\code{POSIXlt}.}

\item{pattern_list}{A list with the desired pattern for each of the following
datetime parts: year, mon, mday, wday, hour, min, sec.}
}
\value{
Vector of the same class as \code{spanned}, containing all the data points in
\code{spanned} that meets the requirements in \code{pattern_list}.
}
\description{
Take a \code{Date}, \code{POSIXct}, or \code{POSIXlt} vector and subset it by
a pattern of date and/or time parts.
}
\details{
For subsetting weekdays, they run from 0 (Sunday) to 6 (Saturday).
}
\examples{
date_span <- span_date(20170701, len_out = 100)
subset_span(date_span, list(wday = 1:5))

time_span <- span_time("20170101 00", 201702)
subset_span(time_span, list(hour = 7:17))
subset_span(time_span, list(hour = c(10, 16), mday = seq(5, 30, 5)))
}
