% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ordfor.R
\name{predict.ordfor}
\alias{predict.ordfor}
\title{Prediction using ordinal forest objects}
\usage{
\method{predict}{ordfor}(object, newdata, ...)
}
\arguments{
\item{object}{object of class \code{ordfor}. See function \code{\link{ordfor}}.}

\item{newdata}{data.frame. Data frame containing new data.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{predict.ordfor} returns an object of class \code{ordforpred}.
An object of class "\code{ordforpred}" is a list containing the following components: 
\item{ypred}{ vector of length \code{nrow(newdata)}. Factor-valued test data predictions. }
\item{classprobs}{ predicted class probabilities. Only provided, if the performance function based on the ranked probability score was used, while training the ordinal forest (see \code{\link{ordfor}}).
Matrix of dimension \code{nrow(newdata)} x J (NA, if the ranked probability was not used while training). The value in the j-th column of the i-th row contains the predicted probability that test observation i is of class j. }
}
\description{
Prediction of test data using ordinal forest.
}
\examples{
data(hearth)

set.seed(123)
trainind <- sort(sample(1:nrow(hearth), size=floor(nrow(hearth)*(1/2))))
testind <- sort(sample(setdiff(1:nrow(hearth), trainind), size=20))

datatrain <- hearth[trainind,]
datatest <- hearth[testind,]

ordforres <- ordfor(depvar="Class", data=datatrain, nsets=50, nbest=5, ntreeperdiv=100, 
  ntreefinal=1000)
# NOTE: nsets=50 is not enough, because the prediction performance of the resulting 
# ordinal forest will be suboptimal!! In practice, nsets=1000 (default value) or a larger
# number should be used.

preds <- predict(ordforres, newdata=datatest)
preds
 
table(data.frame(true_values=datatest$Class, predictions=preds$ypred))

head(preds$classprobs)

}
\references{
Hornung R. (2020) Ordinal Forests. Journal of Classification 37, 4–17. <\doi{10.1007/s00357-018-9302-x}>.
}
