% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_names.R
\name{project_names}
\alias{project_names}
\alias{project_names,ProjectProblem-method}
\title{Project names}
\usage{
project_names(x)

\S4method{project_names}{ProjectProblem}(x)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}}.}
}
\value{
\code{character} project names.
}
\description{
Extract the names of the projects in an object.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with default solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_default_solver()

# print problem
print(p)

# print project names
project_names(p)
}
