% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_clone_worksheet}
\alias{wb_clone_worksheet}
\title{Create copies of a worksheet within a workbook}
\usage{
wb_clone_worksheet(wb, old = current_sheet(), new = next_sheet(), from = NULL)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{old}{Name of existing worksheet to copy}

\item{new}{Name of the new worksheet to create}

\item{from}{(optional) Workbook to clone old from}
}
\value{
The \code{wbWorkbook} object, invisibly.
}
\description{
Create a copy of a worksheet in the same \code{wbWorkbook} object.

Cloning is possible only to a limited extent. References to sheet names in
formulas, charts, pivot tables, etc. may not be updated. Some elements like
named ranges and slicers cannot be cloned yet.

Cloning from another workbook is still an experimental feature and might not
work reliably. Cloning data, media, charts and tables should work. Slicers
and pivot tables as well as everything everything relying on dxfs styles
(e.g. custom table styles and conditional formatting) is currently not
implemented.
Formula references are not updated to reflect interactions between workbooks.
}
\examples{
# Create a new workbook
wb <- wb_workbook()

# Add worksheets
wb$add_worksheet("Sheet 1")
wb$clone_worksheet("Sheet 1", new = "Sheet 2")
# Take advantage of waiver functions
wb$clone_worksheet(old = "Sheet 1")

## cloning from another workbook

# create a workbook
wb <- wb_workbook()$
add_worksheet("NOT_SUM")$
  add_data(x = head(iris))$
  add_fill(dims = "A1:B2", color = wb_color("yellow"))$
  add_border(dims = "B2:C3")

# we will clone this styled chart into another workbook
fl <- system.file("extdata", "oxlsx2_sheet.xlsx", package = "openxlsx2")
wb_from <- wb_load(fl)

# clone styles and shared strings
wb$clone_worksheet(old = "SUM", new = "SUM", from = wb_from)

}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
