% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_cell_style}
\alias{create_cell_style}
\title{Create cell style}
\usage{
create_cell_style(
  border_id = "",
  fill_id = "",
  font_id = "",
  num_fmt_id = "",
  pivot_button = "",
  quote_prefix = "",
  xf_id = "",
  horizontal = "",
  indent = "",
  justify_last_line = "",
  reading_order = "",
  relative_indent = "",
  shrink_to_fit = "",
  text_rotation = "",
  vertical = "",
  wrap_text = "",
  ext_lst = "",
  hidden = "",
  locked = "",
  ...
)
}
\arguments{
\item{border_id, fill_id, font_id, num_fmt_id}{IDs for style elements.}

\item{pivot_button}{Logical parameter for the pivot button.}

\item{quote_prefix}{Logical parameter for the quote prefix. (This way a number in a character cell will not cause a warning).}

\item{xf_id}{Dummy parameter for the xf ID. (Used only with named format styles).}

\item{horizontal}{Character, alignment can be '', 'general', 'left', 'center', 'right', 'fill', 'justify', 'centerContinuous', 'distributed'.}

\item{indent}{Integer parameter for the indent.}

\item{justify_last_line}{Logical for justifying the last line.}

\item{reading_order}{Logical parameter for reading order. 0 (Left to right; default) or 1 (right to left).}

\item{relative_indent}{Dummy parameter for relative indent.}

\item{shrink_to_fit}{Logical parameter for shrink to fit.}

\item{text_rotation}{Integer parameter for text rotation (-180 to 180).}

\item{vertical}{Character, alignment can be '', 'top', 'center', 'bottom', 'justify', 'distributed'.}

\item{wrap_text}{Logical parameter for wrap text. (Required for linebreaks).}

\item{ext_lst}{Dummy parameter for extension list.}

\item{hidden}{Logical parameter for hidden.}

\item{locked}{Logical parameter for locked. (Impacts the cell only).}

\item{...}{Reserved for additional arguments.}
}
\value{
A formatted cell style object to be used in a spreadsheet.
}
\description{
This function creates a cell style for a spreadsheet, including attributes such as borders, fills, fonts, and number formats.
}
\details{
A single cell style can make use of various other styles like border, fill, and font. These styles are independent of the cell style and must be registered with the style manager separately.
This allows multiple cell styles to share a common font type, for instance. The used style elements are passed to the cell style via their IDs. An example of this can be seen below.
The number format can be a custom one created by \code{\link[=create_numfmt]{create_numfmt()}}, or a built-in style from the formats table below.\tabular{ll}{
   "ID" \tab "numFmt" \cr
   "0" \tab "General" \cr
   "1" \tab "0" \cr
   "2" \tab "0.00" \cr
   "3" \tab "#,##0" \cr
   "4" \tab "#,##0.00" \cr
   "9" \tab "0\%" \cr
   "10" \tab "0.00\%" \cr
   "11" \tab "0.00E+00" \cr
   "12" \tab "# ?/?" \cr
   "13" \tab "# ??/??" \cr
   "14" \tab "mm-dd-yy" \cr
   "15" \tab "d-mmm-yy" \cr
   "16" \tab "d-mmm" \cr
   "17" \tab "mmm-yy" \cr
   "18" \tab "h:mm AM/PM" \cr
   "19" \tab "h:mm:ss AM/PM" \cr
   "20" \tab "h:mm" \cr
   "21" \tab "h:mm:ss" \cr
   "22" \tab "m/d/yy h:mm" \cr
   "37" \tab "#,##0 ;(#,##0)" \cr
   "38" \tab "#,##0 ;[Red](#,##0)" \cr
   "39" \tab "#,##0.00;(#,##0.00)" \cr
   "40" \tab "#,##0.00;[Red](#,##0.00)" \cr
   "45" \tab "mm:ss" \cr
   "46" \tab "[h]:mm:ss" \cr
   "47" \tab "mmss.0" \cr
   "48" \tab "##0.0E+0" \cr
   "49" \tab "@" \cr
}
}
\examples{
foo_fill <- create_fill(patternType = "lightHorizontal",
                        fgColor = wb_color("blue"),
                        bgColor = wb_color("orange"))
foo_font <- create_font(sz = 36, b = TRUE, color = wb_color("yellow"))

wb <- wb_workbook()
wb$styles_mgr$add(foo_fill, "foo")
wb$styles_mgr$add(foo_font, "foo")

foo_style <- create_cell_style(
  fill_id = wb$styles_mgr$get_fill_id("foo"),
  font_id = wb$styles_mgr$get_font_id("foo")
)

}
\seealso{
\code{\link[=wb_add_cell_style]{wb_add_cell_style()}}

Other style creating functions: 
\code{\link{create_border}()},
\code{\link{create_colors_xml}()},
\code{\link{create_dxfs_style}()},
\code{\link{create_fill}()},
\code{\link{create_font}()},
\code{\link{create_numfmt}()},
\code{\link{create_tablestyle}()}
}
\concept{style creating functions}
