% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_worksheet}
\alias{wb_add_worksheet}
\title{Add a worksheet to a workbook}
\usage{
wb_add_worksheet(
  wb,
  sheet = next_sheet(),
  gridLines = TRUE,
  rowColHeaders = TRUE,
  tabColour = NULL,
  zoom = 100,
  header = NULL,
  footer = NULL,
  oddHeader = header,
  oddFooter = footer,
  evenHeader = header,
  evenFooter = footer,
  firstHeader = header,
  firstFooter = footer,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  hasDrawing = FALSE,
  paperSize = getOption("openxlsx2.paperSize", default = 9),
  orientation = getOption("openxlsx2.orientation", default = "portrait"),
  hdpi = getOption("openxlsx2.hdpi", default = getOption("openxlsx2.dpi", default = 300)),
  vdpi = getOption("openxlsx2.vdpi", default = getOption("openxlsx2.dpi", default = 300))
)
}
\arguments{
\item{wb}{A Workbook object to attach the new worksheet}

\item{sheet}{A name for the new worksheet}

\item{gridLines}{A logical. If \code{FALSE}, the worksheet grid lines will be
hidden.}

\item{rowColHeaders}{A logical. If \code{FALSE}, the worksheet colname and rowname will be
hidden.}

\item{tabColour}{Colour of the worksheet tab. A valid colour (belonging to
colours()) or a valid hex colour beginning with "#"}

\item{zoom}{A numeric between 10 and 400. Worksheet zoom level as a
percentage.}

\item{header, oddHeader, evenHeader, firstHeader, footer, oddFooter, evenFooter, firstFooter}{Character vector of length 3 corresponding to positions left, center,
right.  \code{header} and \code{footer} are used to default additional arguments.
Setting \code{even}, \code{odd}, or \code{first}, overrides \code{header}/\code{footer}. Use \code{NA} to
skip a position.}

\item{visible}{If FALSE, sheet is hidden else visible.}

\item{hasDrawing}{If TRUE prepare a drawing output (TODO does this work?)}

\item{paperSize}{An integer corresponding to a paper size. See ?ws_page_setup for
details.}

\item{orientation}{One of "portrait" or "landscape"}

\item{hdpi}{Horizontal DPI. Can be set with options("openxlsx2.dpi" = X) or
options("openxlsx2.hdpi" = X)}

\item{vdpi}{Vertical DPI. Can be set with options("openxlsx2.dpi" = X) or
options("openxlsx2.vdpi" = X)}
}
\value{
The \link{wbWorkbook} object \code{wb}
}
\description{
Add a worksheet to a workbook
}
\details{
Headers and footers can contain special tags \itemize{
\item{\strong{&[Page]}}{ Page number} \item{\strong{&[Pages]}}{ Number of pages}
\item{\strong{&[Date]}}{ Current date} \item{\strong{&[Time]}}{ Current time}
\item{\strong{&[Path]}}{ File path} \item{\strong{&[File]}}{ File name}
\item{\strong{&[Tab]}}{ Worksheet name} }
}
\examples{
## Create a new workbook
wb <- wb_workbook("Fred")

## Add 3 worksheets
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2", gridLines = FALSE)
wb$add_worksheet("Sheet 3", tabColour = "red")
wb$add_worksheet("Sheet 4", gridLines = FALSE, tabColour = "#4F81BD")

## Headers and Footers
wb$add_worksheet("Sheet 5",
  header = c("ODD HEAD LEFT", "ODD HEAD CENTER", "ODD HEAD RIGHT"),
  footer = c("ODD FOOT RIGHT", "ODD FOOT CENTER", "ODD FOOT RIGHT"),
  evenHeader = c("EVEN HEAD LEFT", "EVEN HEAD CENTER", "EVEN HEAD RIGHT"),
  evenFooter = c("EVEN FOOT RIGHT", "EVEN FOOT CENTER", "EVEN FOOT RIGHT"),
  firstHeader = c("TOP", "OF FIRST", "PAGE"),
  firstFooter = c("BOTTOM", "OF FIRST", "PAGE")
)

wb$add_worksheet("Sheet 6",
  header = c("&[Date]", "ALL HEAD CENTER 2", "&[Page] / &[Pages]"),
  footer = c("&[Path]&[File]", NA, "&[Tab]"),
  firstHeader = c(NA, "Center Header of First Page", NA),
  firstFooter = c(NA, "Center Footer of First Page", NA)
)

wb$add_worksheet("Sheet 7",
  header = c("ALL HEAD LEFT 2", "ALL HEAD CENTER 2", "ALL HEAD RIGHT 2"),
  footer = c("ALL FOOT RIGHT 2", "ALL FOOT CENTER 2", "ALL FOOT RIGHT 2")
)

wb$add_worksheet("Sheet 8",
  firstHeader = c("FIRST ONLY L", NA, "FIRST ONLY R"),
  firstFooter = c("FIRST ONLY L", NA, "FIRST ONLY R")
)

## Need data on worksheet to see all headers and footers
wb$add_data(sheet = 5, 1:400)
wb$add_data(sheet = 6, 1:400)
wb$add_data(sheet = 7, 1:400)
wb$add_data(sheet = 8, 1:400)
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
