% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp-plan.R
\name{otp_plan}
\alias{otp_plan}
\title{Get get a route or routes from the OTP}
\usage{
otp_plan(
  otpcon = NA,
  fromPlace = NA,
  toPlace = NA,
  fromID = NULL,
  toID = NULL,
  mode = "CAR",
  date_time = Sys.time(),
  arriveBy = FALSE,
  maxWalkDistance = 1000,
  numItineraries = 3,
  routeOptions = NULL,
  full_elevation = FALSE,
  get_geometry = TRUE,
  ncores = 1,
  timezone = otpcon$timezone
)
}
\arguments{
\item{otpcon}{OTP connection object produced by otp_connect()}

\item{fromPlace}{Numeric vector, Longitude/Latitude pair,
e.g. `c(-0.134649,51.529258)`, or 2 column matrix of
Longitude/Latitude pairs, or sf data frame of POINTS
with CRS 4326}

\item{toPlace}{Numeric vector, Longitude/Latitude pair,
e.g. `c(-0.088780,51.506383)`, or 2 column matrix of
Longitude/Latitude pairs, or sf data frame of POINTS
with CRS 4326}

\item{fromID}{character vector same length as fromPlace}

\item{toID}{character vector same length as toPlace}

\item{mode}{character vector of one or more modes of travel valid values
TRANSIT, WALK, BICYCLE, CAR, BUS, RAIL, default CAR. Not all
combinations are valid e.g. c("WALK","BUS") is valid but
c("WALK","CAR") is not.}

\item{date_time}{POSIXct, a date and time, defaults to current
date and time}

\item{arriveBy}{Logical, Whether the trip should depart or arrive
at the specified date and time, default FALSE}

\item{maxWalkDistance}{Numeric passed to OTP in metres}

\item{numItineraries}{The maximum number of possible itineraries to return}

\item{routeOptions}{Named list of values passed to OTP use `otp_route_options()`
to make template object.}

\item{full_elevation}{Logical, should the full elevation profile be returned,
default FALSE}

\item{get_geometry}{Logical, should the route geometry be returned,
default TRUE, see details}

\item{ncores}{Numeric, number of cores to use when batch processing,
default 1, see details}

\item{timezone}{Character, what timezone to use, see as.POSIXct, default is
local timezone}
}
\value{
Returns an SF data frame of LINESTRINGs
}
\description{
This is the main routing function for OTP and can find single or
    multiple routes between
`fromPlace` and `toPlace`.
}
\details{
This function returns a SF data.frame with one row for each leg
of the journey (a leg is defined by a change in mode). For transit,
more than one route option may be returned and is indicated by the
`route_option` column. The number of different itineraries can be
set with the `numItineraries` variable.

## Batch Routing

When passing a matrix or SF data frame object to fromPlace and toPlace
`otp_plan` will route in batch mode. In this case the `ncores` variable
will be used. Increasing `ncores` will enable multicore routing, the max
 `ncores` should be the number of cores on your system - 1.

## Elevation

OTP supports elevation data and can return the elevation profile of the
route if available. OTP returns the elevation profile separately from the
XY coordinates, this means there is not direct match between the number of
 XY points and the number of Z points.  OTP also only returns the
elevation profile for the first leg of the route (this appears to be a bug).
As a default, the otp_plan function matches the elevation profile to the
XY coordinates to return an SF linestring with XYZ coordinates. If you
require a more detailed elevation profile, the full_elevation parameter
will return a nested data.frame with three columns. first and second
are returned from OTP, while distance is the cumulative distance along the
route and is derived from First.

## Route Geometry

The `get_geometry` provides the option to not return the route geometry,
and just return the meta-data (e.g. journey time). This may be useful when
creating an Origin:Destination matrix and also provides a small
performance boost by reduced processing of geometries.
}
\examples{
\dontrun{
otpcon <- otp_connect()
otp_plan(otpcon, c(0.1, 55.3), c(0.6, 52.1))
otp_plan(otpcon, c(0.1, 55.3), c(0.6, 52.1),
  mode = c("WALK", "TRANSIT")
)
otp_plan(otpcon, c(0.1, 55.3), c(0.6, 52.1),
  mode = "BICYCLE", arriveBy = TRUE,
  date_time = as.POSIXct(strptime("2018-06-03 13:30", "\%Y-\%m-\%d \%H:\%M"))
)
}

}
\seealso{
Other routing: 
\code{\link{otp_geocode}()},
\code{\link{otp_isochrone}()},
\code{\link{otp_routing_options}()},
\code{\link{otp_validate_routing_options}()}
}
\concept{routing}
