% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.admin.R
\name{oadmin.system_metrics}
\alias{oadmin.system_metrics}
\title{Get system metrics}
\usage{
oadmin.system_metrics(opal)
}
\arguments{
\item{opal}{Opal connection object.}
}
\description{
Get some metrics about the Opal system status. The following information are returned:
`timestamp` (the EPOC time at which the metrics were collected),
`uptime` (the running time in millis),
`heapMemory` (the memory currently used),
`nonHeapMemory` (the memory that can be used),
`threads` (the current (count) and maximum (peak) numbers of threads),
`gcs` (the garbage collectors activity).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.system_metrics(o)
opal.logout(o)
}
}
