% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_forest.R
\name{random_forest}
\alias{random_forest}
\title{random_forest
Perform a classification or regression random forest model}
\usage{
random_forest(
  count_data,
  metadata,
  model,
  training_proportion = c(80, 20),
  n_tree = 500
)
}
\arguments{
\item{count_data}{Metabolomics data}

\item{metadata}{sample data}

\item{model}{a model of format variable ~.}

\item{training_proportion}{a numeric vector of length 2, first element is the percent of
samples to use for training the model, second element is the percent of samples used to
test the models accuracy}

\item{n_tree}{number of decision trees to create}
}
\description{
a wrapper built around the randomForest function from package randomForest.
Returns a list with a randomForest object list, training data set, testing data set,
metabolite metadata, and confusion matrices for training and testing data
(if type was classification).
}
\examples{
rf_list <- random_forest(count_data = c57_nos2KO_mouse_countDF,metadata = c57_nos2KO_mouse_metadata,
model = Treatment ~.,training_proportion = c(60,40),n_tree = 500)
}
