% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.summarised_result}
\alias{summary.summarised_result}
\title{Summary a summarised_result}
\usage{
\method{summary}{summarised_result}(object, ...)
}
\arguments{
\item{object}{A summarised_result object.}

\item{...}{For compatibility (not used).}
}
\value{
A summary of the result_types contained in a summarised_result
object.
}
\description{
Summary a summarised_result
}
\examples{
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
 )
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2025-12-31"),
  period_type_concept_id = 0
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test"
)

result <- summary(cdm)

summary(result)

}
