% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\name{plot,met-method}
\alias{plot,met-method}
\alias{plot.met}
\title{Plot a met Object}
\usage{
\S4method{plot}{met}(x, which = 1:4, mgp, mar, tformat, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{a \linkS4class{met} object.}

\item{which}{list of desired plot types.
\itemize{
\item \code{which=1} gives a time-series plot of temperature
\item \code{which=2} gives a time-series plot of pressure
\item \code{which=3} gives a time-series plot of the x (eastward) component of velocity
\item \code{which=4} gives a time-series plot of the y (northward) component of velocity
\item \code{which=5} gives a time-series plot of speed
\item \code{which=6} gives a time-series plot of direction (degrees clockwise from north;
note that the values returned by \code{met[["direction"]]} must be multiplied by 10
to get the direction plotted)
}}

\item{mgp}{A 3-element numerical vector used with \code{\link{par}}\code{("mgp")}
to control the spacing of axis elements.  The default is tighter than the R default.}

\item{mar}{A 4-element numerical vector used with \code{\link{par}}\code{("mar")}
to control the plot margins. The default is tighter than the R default.}

\item{tformat}{optional argument passed to \code{\link[=oce.plot.ts]{oce.plot.ts()}}, for
plot types that call that function.  (See \code{\link[=strptime]{strptime()}} for the
format used.)}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Creates a multi-panel summary plot of data measured in a meteorological data
set.  cast. The panels are controlled by the \code{which} argument.
}
\details{
If more than one panel is drawn, then on exit from \code{plot.met}, the
value of \code{par} will be reset to the value it had before the function
call.  However, if only one panel is drawn, the adjustments to \code{par}
made within \code{plot.met} are left in place, so that further additions may
be made to the plot.
}
\examples{
library(oce)
data(met)
plot(met, which=3:4)

## Wind speed and direction during Hurricane Juan
## Compare with the final figure in a white paper by Chris Fogarty
## (available at http://www.novaweather.net/Hurricane_Juan_files/McNabs_plot.pdf
## downloaded 2017-01-02).
library(oce)
data(met)
t0 <- as.POSIXct("2003-09-29 04:00:00", tz="UTC")
dt <- 12 * 3600
juan <- subset(met, t0 - dt <= time & time <= t0 + dt)
par(mfrow=c(2,1))
plot(juan, which=5)
abline(v=t0)
plot(juan, which=6)
abline(v=t0)

}
\seealso{
Other functions that plot oce data: 
\code{\link{download.amsr}()},
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to met data: 
\code{\link{[[,met-method}},
\code{\link{[[<-,met-method}},
\code{\link{as.met}()},
\code{\link{download.met}()},
\code{\link{met-class}},
\code{\link{met}},
\code{\link{read.met}()},
\code{\link{subset,met-method}},
\code{\link{summary,met-method}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to met data}
