% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceColorsGebco}
\alias{oceColorsGebco}
\alias{oce.colorsGebco}
\title{Create colors in a Gebco-like scheme}
\usage{
oceColorsGebco(
  n = 9,
  region = c("water", "land", "both"),
  type = c("fill", "line"),
  debug = getOption("oceDebug")
)
}
\arguments{
\item{n}{Number of colors to return}

\item{region}{String indicating application region,
one of \code{"water"}, \code{"land"}, or \code{"both"}.}

\item{type}{String indicating the purpose, one of \code{"fill"} or \code{"line"}.}

\item{debug}{a flag that turns on debugging.}
}
\description{
The colours were determined by examination of paper
charts printed during the GEBCO Fifth Edition era.
The hues range from dark blue to light blue, then
from light brown to dark brown.  If used to show
topography in scheme centred on z=0, this means that
near-coastal regions are light in tone, with darker
colours representing both mountains and the deep sea.
}
\examples{
library(oce)
imagep(volcano, col=oceColorsGebco(128, region="both"))

}
\seealso{
Other things related to colors: 
\code{\link{colormapGMT}()},
\code{\link{colormap}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTurbo}()},
\code{\link{oceColorsTwo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}
}
\concept{things related to colors}
