% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{subset,xbt-method}
\alias{subset,xbt-method}
\title{Subset an xbt Object}
\usage{
\S4method{subset}{xbt}(x, subset, ...)
}
\arguments{
\item{x}{an \linkS4class{xbt} object.}

\item{subset}{a condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{...}{ignored.}
}
\value{
A new \code{xbt} object.
}
\description{
This function is somewhat analogous to \code{\link[=subset.data.frame]{subset.data.frame()}}.
}
\examples{
library(oce)
data(xbt)
plot(xbt)
plot(subset(xbt, depth < mean(range(xbt[["depth"]]))))

}
\seealso{
Other things related to xbt data: 
\code{\link{[[,xbt-method}},
\code{\link{[[<-,xbt-method}},
\code{\link{as.xbt}()},
\code{\link{plot,xbt-method}},
\code{\link{read.xbt.noaa1}()},
\code{\link{read.xbt}()},
\code{\link{summary,xbt-method}},
\code{\link{xbt-class}},
\code{\link{xbt.edf}},
\code{\link{xbt}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to xbt data}
