% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceEdit}
\alias{oceEdit}
\alias{oce.edit}
\title{Edit an Oce Object}
\usage{
oceEdit(
  x,
  item,
  value,
  action,
  reason = "",
  person = "",
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{an \linkS4class{oce} object.  The exact action of \code{\link[=oceEdit]{oceEdit()}} depends
on the sub-class of \code{x}.}

\item{item}{if supplied, a character string naming an item in the object's
\code{metadata} or \code{data} slot, the former being checked first.
An exception is if \code{item} starts with \code{"data@"} or
\code{"metadata@"}, in which case the named slot is updated with a changed
value of the contents of \code{item} after the \code{@} character.}

\item{value}{new value for \code{item}, if both supplied.}

\item{action}{optional character string containing R code to carry out some
action on the object.}

\item{reason}{character string giving the reason for the change.}

\item{person}{character string giving the name of person making the change.}

\item{debug}{an integer that specifies a level of debugging, with 0 or less
indicating no debugging, and 1 or more indicating debugging.}
}
\value{
A \linkS4class{oce} object, altered
appropriately, and with a log item indicating the nature of the alteration.
}
\description{
Edit an element of an oce object, inserting a note in the processing
log of the returned object.
}
\details{
There are several ways to use this function.
\enumerate{
\item If both an \code{item} and \code{value} are supplied, then
either the object's metadata or data slot may be altered. There are
two ways in which this can be done.
\itemize{
\item Case 1A. If the \code{item} string does not contain an
\code{@} character, then the \code{metadata} slot is examined
for an entry named \code{item}, and that is modified if so.
Alternatively, if \code{item} is found in \code{metadata}, then
that value is modified. However, if \code{item} is not found in
either \code{metadata} or \code{data}, then an error is reported
(see 1B for how to add something that does not yet exist).
\item Case 1B. If the \code{item} string contains
the \code{@} character, then the text to the left of that character
must be either \code{"metadata"} or \code{"data"}, and it names the slot
in which the change is done. In contrast with case 1A, this will
\emph{create} a new item, if it is not already in existence.
}
\item If \code{item} and \code{value} are not supplied, then \code{action} must
be supplied.  This is a character string specifying some action to be
performed on the object, e.g. a manipulation of a column.  The action must
refer to the object as \code{x}; see Examples.
}

In any case, a log entry is stored in the object, to document the change.
Indeed, this is the main benefit to using this function, instead of altering
the object directly.  The log entry will be most useful if it contains a
brief note on the \code{reason} for the change, and the name of the
\code{person} doing the work.
}
\examples{
library(oce)
data(ctd)
ctd2 <- oceEdit(ctd, item="latitude", value=47.8879,
               reason="illustration", person="Dan Kelley")
ctd3 <- oceEdit(ctd,action="x@data$pressure<-x@data$pressure-1")
}
\author{
Dan Kelley
}
