% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{[[,amsr-method}
\alias{[[,amsr-method}
\title{Extract Something From an amsr Object}
\usage{
\S4method{[[}{amsr}(x, i, j, ...)
}
\arguments{
\item{x}{an \linkS4class{amsr} object.}

\item{i}{Character string indicating the name of an item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\value{
In all cases, the returned value is a matrix with
with \code{NA} values inserted at locations where
the raw data equal \code{as.raw(251:255)}, as explained
in \dQuote{Details}.
}
\description{
Extract something from the \code{metadata} or \code{data} slot of an \linkS4class{amsr} object.
Partial matches for \code{i}
are permitted for \code{metadata}, and \code{j} is ignored for
\code{metadata}.

The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \linkS4class{oce}.  The purpose
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items that are not actually stored in
the object can also be extracted, including derived data such
as potential temperature, the units of measurement for
the data, data-quality flags, etc.
}
\details{
Data within the \code{data} slot may be found directly, e.g.
\code{i="SSTDay"} will yield sea-surface temperature in the daytime
satellite, and \code{i="SSTNight"} is used to access the nighttime data. In
addition, \code{i="SST"} yields a computed average of the night and day values
(using just one of these, if the other is missing). This scheme of
providing computed averages works for
all the data stored in \code{amsr} objects, namely:
\code{time}, \code{SST}, \code{LFwind}, \code{MFwind},
\code{vapor}, \code{cloud} and \code{rain}.  In each case, the default
is to calculate values in scientific units, unless \code{j="raw"}, in
which case the raw data are returned.

The conversion from raw to scientific units is done with formulae
found at \verb{http://www.remss.com/missions/amsre}, e.g. SST is
computed by converting the raw value to an integer (between 0 and 255),
multiplying by 0.15C, and subtracting 3C.

The \code{"raw"} mode can be useful
in decoding the various types of missing value that are used by \code{amsr}
data, namely \code{as.raw(255)} for land, \code{as.raw(254)} for
a missing observation, \code{as.raw(253)} for a bad observation,
\code{as.raw(252)} for sea ice, or \code{as.raw(251)} for missing SST
due to rain or missing water vapour due to heavy rain. Note that
something special has to be done for e.g. \code{d[["SST","raw"]]}
because the idea is that this syntax (as opposed to specifying
\code{"SSTDay"}) is a request to try to find good
data by looking at both the Day and Night measurements. The scheme
employed is quite detailed. Denote by "A" the raw value of the desired field
in the daytime pass, and by "B" the corresponding value in the
nighttime pass. If either A or B is 255, the code for land, then the
result will be 255. If A is 254 (i.e. there is no observation),
then B is returned, and the reverse holds also. Similarly, if either
A or B equals 253 (bad observation), then the other is returned.
The same is done for code 252 (ice) and code 251 (rain).

A two-step process is used to try to find the
requested information. First, a class-specific function
tries to find it, but
if that fails, then a general function is used
(see next section).
}
\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the values of \code{i} and, optionally, \code{j}. The work
proceeds in steps, by testing a sequence of possible conditions
in sequence.
\enumerate{
\item A check is made as to whether \code{i} names one of the standard
\code{oce} slots. If so, \code{[[} returns the slot contents of that slot.
Thus, \code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.
\item If \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link[=expression]{expression()}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]} (note the space),
then just the expression is returned, and if it ends in
\code{" scale"}, then just the scale is returned.
\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.
\item If \code{i} is \code{"sigmaTheta"}, then the value of
\code{\link[=swSigmaTheta]{swSigmaTheta()}} is called with \code{x} as the sole
argument, and the results are returned. Similarly,
\code{\link[=swSigma0]{swSigma0()}} is used if \code{i="sigma0"}, and
\code{\link[=swSpice]{swSpice()}} is used if \code{i="spice"}. Of course, these
actions only make sense for objects that contain
the relevant items within their \code{data} slot.
\item After these possibilities are eliminated,
the action depends on whether \code{j} has been provided.
If \code{j} is not provided, or is the string \code{""},
then \code{i} is sought
in the \code{metadata} slot, and then in the \code{data} slot,
returning whichever is found first.  In other words, if \code{j}
is not provided, the \code{metadata} slot takes preference over
the \code{data} slot. However, if \code{j} is provided, then
it must be either the string \code{"metadata"} or \code{"data"},
and it directs where to look.
}

If none of the above-listed conditions holds, then \code{NULL} is returned,
without the issuance of a warning or error message. (This silent operation
is employed so that \code{[[} will behave like the normal R version.)
}

\examples{
# Histogram of SST values
library(oce)
data(amsr)
hist(amsr[["SST"]])

}
\seealso{
Other functions that extract parts of oce objects: 
\code{\link{[[,adp-method}},
\code{\link{[[,adv-method}},
\code{\link{[[,argo-method}},
\code{\link{[[,bremen-method}},
\code{\link{[[,cm-method}},
\code{\link{[[,coastline-method}},
\code{\link{[[,ctd-method}},
\code{\link{[[,echosounder-method}},
\code{\link{[[,g1sst-method}},
\code{\link{[[,gps-method}},
\code{\link{[[,ladp-method}},
\code{\link{[[,landsat-method}},
\code{\link{[[,lisst-method}},
\code{\link{[[,lobo-method}},
\code{\link{[[,met-method}},
\code{\link{[[,oce-method}},
\code{\link{[[,odf-method}},
\code{\link{[[,rsk-method}},
\code{\link{[[,sealevel-method}},
\code{\link{[[,section-method}},
\code{\link{[[,tidem-method}},
\code{\link{[[,topo-method}},
\code{\link{[[,windrose-method}},
\code{\link{[[,xbt-method}},
\code{\link{[[<-,adv-method}}

Other things related to amsr data: 
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{amsr}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to amsr data}
