% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\docType{methods}
\name{summary,lobo-method}
\alias{summary,lobo-method}
\title{Summarize a LOBO Object}
\usage{
\S4method{summary}{lobo}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"lobo"}, usually, a result of a call
to \code{\link{read.lobo}} or \code{\link{read.oce}}.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A matrix containing statistics of the elements of the \code{data}
slot.
}
\description{
Pertinent summary information is presented, including the sampling interval,
data ranges, etc.
}
\examples{

library(oce)
data(lobo)
summary(lobo)
}
\references{
\url{http://lobo.satlantic.com} \url{http://www.mbari.org/lobo/}
}
\seealso{
The documentation for \code{\link{lobo-class}} explains the
structure of LOBO objects, and also outlines the other functions dealing
with them.

Other things related to \code{lobo} data: \code{\link{[[,lobo-method}},
  \code{\link{[[<-,lobo-method}}, \code{\link{as.lobo}},
  \code{\link{lobo-class}}, \code{\link{lobo}},
  \code{\link{plot,lobo-method}},
  \code{\link{subset,lobo-method}}
}
\author{
Dan Kelley
}
\concept{things related to \code{lobo} data}
