% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{oceSetData}
\alias{oceSetData}
\title{Set something in the \code{data} slot of an \code{oce} object}
\usage{
oceSetData(object, name, value, unit, originalName, note = "")
}
\arguments{
\item{object}{an \code{oce} object}

\item{name}{String indicating the name of the item to be set.}

\item{value}{Value for the item.}

\item{unit}{An optional indication of the units for the item. This has
three possible forms (see \dQuote{Details}).}

\item{originalName}{Optional character string giving an 'original' name (e.g.
as stored in the header of a data file).}

\item{note}{A note to be stored in the processing log. If an empty string
(the default) then an entry will be constructed from the function call. If
\code{NULL}, then no entry will be added to the processing log.}
}
\description{
Set something in the \code{data} slot of an \code{oce} object
}
\details{
There are three possibilities for \code{unit}:
\itemize{
\item \emph{Case 1.} \code{unit} is a named or unnamed \code{\link{list}}
that contains two items.
If the list is named, the names must be
\code{unit} and \code{scale}. If the list is unnamed, the stated names are assigned
to the items, in the stated order. Either way, the \code{unit}
item must be an \code{\link{expression}} that specifies the unit,
and the \code{scale} item must be a string that describes the scale. For
example, modern temperatures have
\code{unit=list(unit=expression(degree*C), scale="ITS-90")}.
\item \emph{Case 2.} \code{unit} is an \code{\link{expression}} giving the unit as above. In this
case, the scale will be set to \code{""}.
\item \emph{Case 3.} \code{unit} is a character string that is converted
into an expression with \code{\link{parse}(text=unit)},
and the scale set to \code{""}.
}
}
\examples{
data(ctd)
Tf <- swTFreeze(ctd)
ctd <- oceSetData(ctd, "freezing", Tf, list(unit=expression(degree*C), scale="ITS-90"))
feet <- swDepth(ctd) / 0.3048
ctd <- oceSetData(ctd, name="depthInFeet", value=feet, expression("feet"))
fathoms <- feet / 6
ctd <- oceSetData(ctd, "depthInFathoms", fathoms, "fathoms")
}
