% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{coriolis}
\alias{coriolis}
\title{Coriolis parameter on rotating earth}
\usage{
coriolis(latitude, degrees = TRUE)
}
\arguments{
\item{latitude}{Vector of latitudes in \eqn{^\circ}{deg}N or radians north of the equator.}

\item{degrees}{Flag indicating whether degrees are used for latitude; if set
to \code{FALSE}, radians are used.}
}
\value{
Coriolis parameter [radian/s].
}
\description{
Compute \eqn{f}{f}, the Coriolis parameter as a function of latitude.
}
\examples{
C <- coriolis(45) # 1e-4
}
\author{
Dan Kelley
}
\references{
Gill, A.E., 1982. \emph{Atmosphere-ocean Dynamics}, Academic
Press, New York, 662 pp.
}

