% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\docType{methods}
\name{subset,ctd-method}
\alias{subset,ctd-method}
\title{Subset a CTD Object}
\usage{
\S4method{subset}{ctd}(x, subset, ...)
}
\arguments{
\item{x}{A \code{ctd} object, i.e. one inheriting from \code{\link{ctd-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{...}{Ignored.}
}
\value{
A \code{ctd} object.
}
\description{
This function is somewhat analogous to
\code{\link{subset.data.frame}}, but only one independent variable may be
used in \code{subset} in any call to the function, which means that
repeated calls will be necessary to subset based on more than one
independent variable (e.g. time and distance).
}
\examples{
library(oce)
data(ctd)
plot(ctd)
plot(subset(ctd, pressure<10))

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdDecimate}}, \code{\link{ctdFindProfiles}},
  \code{\link{ctdRaw}}, \code{\link{ctdTrim}},
  \code{\link{ctd}}, \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

