% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{renameData}
\alias{renameData}
\title{Rename items in the data slot of an oce object}
\usage{
renameData(x, old = NULL, new = NULL)
}
\arguments{
\item{x}{An \code{oce} object, i.e. one inheriting from
\code{\link{oce-class}}.}

\item{old}{Vector of strings, containing old names.}

\item{new}{Vector of strings, containing old names.}
}
\description{
This function may be used to rename elements within the
\code{data} slot of \code{oce} objects. It also updates
the processing log of the returned object, indicating
the changes.
}
\examples{
data(ctd)
new <- renameData(ctd, "temperature", "temperature68")
new <- oceSetData(new, name="temperature",
                  value=T90fromT68(new[["temperature68"]]), 
                  unit=list(unit=expression(degree*C),scale="ITS=90"))
}

