% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\docType{methods}
\name{plot,amsr-method}
\alias{plot,amsr-method}
\title{Plot an amsr Object}
\usage{
\S4method{plot}{amsr}(x, y, asp, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{An object inherting from \code{\link{amsr-class}}.}

\item{y}{String indicating the name of the band to plot; if not provided,
\code{SST} is used; see \code{\link{amsr-class}} for a list of bands.}

\item{asp}{Optional aspect ratio for plot.}

\item{debug}{A debugging flag, integer.}

\item{...}{extra arguments passed to \code{\link{imagep}}, e.g. set
\code{col} to control colours.}
}
\description{
Plot an amsr Object
}
\examples{
\dontrun{
d <- read.amsr("f34_20160102v7.2.gz")
asp <- 1/cos(pi*40/180)
plot(d, "SST", col=oceColorsJet, xlim=c(-80,0), ylim=c(20,60), asp=asp)
data(coastlineWorldMedium, package="ocedata")
lines(coastlineWorldMedium[['longitude']], coastlineWorldMedium[['latitude']])
}

}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{amsr} data: \code{\link{[[<-,amsr-method}},
  \code{\link{amsr-class}}, \code{\link{read.amsr}},
  \code{\link{summary,amsr-method}}
}
\concept{
satellite
}

