% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.woce.R
\name{read.ctd.woce.other}
\alias{read.ctd.woce.other}
\title{Read a WOCE-type CTD file with First Word "EXPOCODE"}
\usage{
read.ctd.woce.other(file, columns = NULL, station = NULL, missingValue,
  monitor = FALSE, debug = getOption("oceDebug"), processingLog, ...)
}
\arguments{
\item{file}{A connection or a character string giving the name of the file to
load.  For \code{read.ctd.sbe()} and \code{read.ctd.woce()}, this may be a
wildcard (e.g. \code{"*.cnv"} or \code{"*.csv"}) in which case the return
value is a vector containing CTD objects created by reading the files from
\code{\link{list.files}} with \code{pattern} set to the specified wildcard
pattern.}

\item{columns}{An optional \code{\link{list}} that can be used to convert unrecognized
data names to resultant variable names.  This is used only by
\code{\link{read.ctd.sbe}} and \code{\link{read.ctd.odf}}; see
\dQuote{Examples}.}

\item{station}{Optional character string containing an identifying name or
number for the station. This can be useful if the routine cannot determine the
name automatically, or if another name is preferred.}

\item{missingValue}{Optional missing-value flag; data matching this value will
be set to \code{NA} upon reading. If this is provided, then it overrules any
missing-value flag found in the data. For Seabird (\code{.cnv}) files, there is
usually no need to set \code{missingValue}, because it can be inferred from the
header (typically as -9.990e-29). Set \code{missingValue=NULL} to turn off
missing-value detection, even in \code{.cnv} files that contain missing-value
codes in their headers.}

\item{monitor}{Boolean, set to \code{TRUE} to provide an indication of
progress.  This is useful if \code{filename} is a wildcard.}

\item{debug}{An integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{processingLog}{If provided, the action item to be stored in the log.
This is typically only provided for internal calls; the default that it provides is
better for normal calls by a user.}

\item{...}{additional arguments, passed to called routines.}
}
\value{
An object of \code{\link{ctd-class}}. The details of the contents
depend on the source file. The \code{metadata} slot is particularly 
variable across data formats, because the meta-information provided
in those formats varies widely.
}
\description{
Read a WOCE-type CTD file with First Word "EXPOCODE"
}
\details{
\code{read.ctd.woce.other()} reads files stored in the exchange format used
by the World Ocean Circulation Experiment (WOCE), in which the first
word in the file is \code{EXPOCODE}.
}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdAddColumn}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctdUpdateHeader}},
  \code{\link{ctd}}, \code{\link{gps-class}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}}, \code{\link{read.ctd.woce}},
  \code{\link{read.ctd}}, \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}
}

