% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\docType{methods}
\name{[[,adv-method}
\alias{[[,adv-method}
\title{Extract Something From an adv Object}
\usage{
\S4method{[[}{adv}(x, i, j, ...)
}
\arguments{
\item{x}{An adv object, i.e. one inheriting from \code{\link{adv-class}}.}

\item{i}{The item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
In addition to the usual extraction of elements by name, some shortcuts
are also provided, e.g. \code{u1} retrieves \code{v[,1]}, and similarly
for the other velocity components. The \code{a} and \code{q}
data can be retrived in \code{\link{raw}} form or numeric
form; see examples.
}
\examples{
data(adv)
head(adv[["q"]])            # in raw form
head(adv[["q", "numeric"]]) # in numeric form
}

