% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_metadataformats.R
\name{list_metadataformats}
\alias{list_metadataformats}
\title{List available metadata formats from various providers.}
\usage{
list_metadataformats(url = "http://oai.datacite.org/oai", id = NULL, ...)
}
\arguments{
\item{url}{(character) OAI-PMH base url}

\item{id}{The OAI-PMH identifier for the record. Optional.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List available metadata formats from various providers.
}
\examples{
\dontrun{
list_metadataformats()

# no metadatformats for an identifier
list_metadataformats(id = "oai:oai.datacite.org:22")

# metadatformats available for an identifier
list_metadataformats(id = "oai:oai.datacite.org:32348")

# curl options
library("httr")
list_metadataformats(id = "oai:oai.datacite.org:32348", config = verbose())
}
}

