% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frfast.R
\name{frfast}
\alias{frfast}
\title{Fitting nonparametric models}
\usage{
frfast(formula, data = data, model = "np", smooth = "kernel", h0 = -1,
  h = -1, nh = 30, weights = NULL, kernel = "epanech", p = 3,
  kbin = 100, nboot = 500, rankl = NULL, ranku = NULL, seed = NULL,
  cluster = TRUE, ncores = NULL, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}: a sympbolic 
description of the model to be fitted. The details of model 
specification are given under 'Details'.}

\item{data}{A data frame or matrix containing the model response
variable and covariates required by the \code{formula}.}

\item{model}{Type model used: \code{model = "np"}  nonparametric
regression model, 
\code{model = "allo"} the  allometric model.}

\item{smooth}{Type smoother used: \code{smooth = "kernel"} for local polynomial
kernel smoothers and \code{smooth = "splines"} for splines using the 
\code{mgcv} package.}

\item{h0}{The kernel bandwidth smoothing parameter for the global effect (see
references for more details at the estimation). Large values of the bandwidth lead
to smoothed estimates; smaller values of the bandwidth lead lo undersmoothed estimates. 
By default, cross validation is used to obtain the bandwidth.}

\item{h}{The kernel bandwidth smoothing parameter for the partial effects.}

\item{nh}{Integer number of equally-spaced bandwidth in which the
\code{h} is discretised, to speed up computation in the kernel-based regression.}

\item{weights}{Prior weights on the data.}

\item{kernel}{A character string specifying the desired kernel. 
Defaults to \code{kernel = "epanech"}, where the Epanechnikov
density function kernel will be used. Also, several types of kernel functons 
can be used:  triangular and Gaussian density function, 
with \code{"triang"} and \code{"gaussian"} term, respectively.}

\item{p}{Polynomial degree to be used in the kernel-based regression. Its 
value must be the value of
derivative + 1. The default value is 3, returning 
the estimation, first and second derivative.}

\item{kbin}{Number of binning nodes over which the function 
is to be estimated.}

\item{nboot}{Number of bootstrap repeats. Defaults to 500 bootstrap repeats. 
The wild bootstrap is used when \code{model = "np"} and the simple bootstrap 
when \code{model = "allo"}.}

\item{rankl}{Number or vector specifying the minimum value for the
interval at which to search the \code{x} value which maximizes the
estimate, first or second derivative  (for each level). The default
is the minimum data value.}

\item{ranku}{Number or vector specifying the maximum value for the
interval at which to search the \code{x} value which maximizes the
estimate, first or second derivative  (for each level). The default
is the maximum data value.}

\item{seed}{Seed to be used in the bootstrap procedure.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
bootstrap procedure is  parallelized (only for \code{smooth = "splines"}).
 Note that there are cases 
(e.g., a low number of bootstrap repetitions) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores 
to be used is equal to the number of cores of the machine - 1.}

\item{\ldots}{Other options.}
}
\value{
An object is returned with the following elements:
\item{x}{Vector of values of the grid points at which model is to 
be estimate.}
\item{p}{Matrix of values of the grid points at which to compute the 
estimate, their first and second derivative.}
\item{pl}{Lower values of  95\% confidence interval for the estimate, 
their first and second derivative.}
\item{pu}{Upper values of  95\% confidence interval for the estimate, 
their first and second derivative.}
\item{diff}{Differences between the estimation values of a couple of 
levels (i. e. level 2 - level 1). The same procedure for their first
and second derivative.}
\item{diffl}{Lower values of 95\% confidence interval for the differences 
between the estimation values of a couple of levels. It is performed 
for their first and second derivative.}
\item{diffu}{Upper values of 95\% confidence interval for the differences 
between the estimation values of a couple of levels. It is performed for 
their first and second derivative.}
\item{nboot}{Number of bootstrap repeats.}
\item{n}{Sample size.}
\item{dp}{Degree of polynomial to be used.}
\item{h0}{The kernel bandwidth smoothing parameter for the global effect.}
\item{h}{The kernel bandwidth smoothing parameter for the partial effects.}
\item{fmod}{Factor's level for each data.}
\item{xdata}{Original x values.}
\item{ydata}{Original y values.}
\item{w}{Weights on the data.}
\item{kbin}{Number of binning nodes over which the function is to 
be estimated.}
\item{nf}{Number of levels.}
\item{max}{Value of covariate \code{x} which maximizes the  estimate, 
first or second derivative.}
\item{maxu}{Upper value of 95\% confidence interval for the 
value \code{max}.}
\item{maxl}{Lower value of 95\% confidence interval for the 
value \code{max}.}
\item{diffmax}{Differences between the estimation of \code{max} for a 
couple of levels (i. e. level 2 - level 1). The same procedure for their 
first and second derivative.}
\item{diffmaxu}{Upper value of 95\% confidence interval for the value 
\code{diffmax}.}
\item{diffmaxl}{Lower value of 95\% confidence interval for the value 
\code{diffmax}.}
\item{repboot}{Matrix of values of the grid points at which to compute 
the estimate, their first and second derivative for each bootstrap repeat.}
\item{rankl}{Maximum value for the interval at which to search the 
\code{x} value which maximizes the estimate, first or second derivative  
(for each level). The default is the maximum data value.}
\item{ranku}{Minimum value for the interval at which to search the 
\code{x} value which maximizes the estimate, first or second derivative  
(for each level). The default is the minimum data value.}
\item{nmodel}{Type model used: \code{nmodel = 1} the nonparametric model, 
\code{nmodel = 2} the allometric model.}
\item{label}{Labels of the variables in the model.}
\item{numlabel}{Number of labels.}
\item{kernel}{A character specifying the derised kernel.}
\item{a}{Estimated coefficient in the case of fitting an allometric model.}
\item{al}{Lower value of 95\% confidence interval for the value of \code{a}.}
\item{au}{Upper value of 95\% confidence interval for the value of \code{a}.}
\item{b}{Estimated coefficient in the case of fitting an allometric model.}
\item{bl}{Lower value of 95\% confidence interval for the value of \code{b}.}
\item{bu}{Upper value of 95\% confidence interval for the value of \code{b}.}
\item{name}{Name of the variables in the model.}
\item{formula}{A sympbolic description of the model to be fitted.}
\item{nh}{Integer number of equally-spaced bandwidth on which the
\code{h} is discretised.}
\item{r2}{Coefficient of determination (in the case of the allometric model).}
\item{smooth}{Type smoother used.}
\item{cluster}{Is the procedure parallelized? (for splines smoothers).}
\item{ncores}{Number of cores used in the parallelized procedure? (for splines smoothers).}
}
\description{
This function is used to fit nonparametric models by
using local polynomial kernel smoothers or splines. These models can 
include or not  
factor-by-curve interactions. Additionally, a parametric 
model (allometric model) can be estimated (or not).
}
\details{
The models fitted by \code{frfast} function are specified 
in a compact symbolic form. The \~ operator is basic in the formation 
of such models. An expression of the form \code{y ~ model}  is interpreted as 
a specification that the response \code{y} is modelled by a predictor 
specified symbolically by \code{model}. The possible terms consist of a 
variable name or a variable name and a factor name separated by : operator. 
Such a term is interpreted as the interaction of the continuous variable and 
the factor. However, if \code{smooth = "splines"}, the formula is based on the function
formula.gam of the mgcv package.
}
\examples{
library(npregfast)
data(barnacle)

# Nonparametric regression without interactions
fit <- frfast(DW ~ RC, data = barnacle, nboot = 100, smooth = "kernel") 
fit
summary(fit)

# using  splines
#fit <- frfast(DW ~ s(RC), data = barnacle, nboot = 100, 
#smooth = "splines", cluster = TRUE, ncores = 2) 
#fit
#summary(fit)


# Change the number of binning nodes and bootstrap replicates
fit <- frfast(DW ~ RC, data = barnacle, kbin = 200,
               nboot = 100, smooth = "kernel")

# Nonparametric regression with interactions
fit2 <- frfast(DW ~ RC : F, data = barnacle, nboot = 100)
fit2
summary(fit2)

# using  splines
#fit2 <- frfast(DW ~ s(RC, by = F), data = barnacle,
#               nboot = 100, smooth = "splines", cluster = TRUE, ncores = 2)
#fit2
#summary(fit2)


# Allometric model
fit3 <- frfast(DW ~ RC, data = barnacle, model = "allo", nboot = 100)
summary(fit3)

# fit4 <- frfast(DW ~ RC : F, data = barnacle, model = "allo", nboot = 100)
# summary(fit4)

}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}

