% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdiff.R
\name{plotdiff}
\alias{plotdiff}
\title{Visualization of the differences between the estimated curves 
for two factor's levels}
\usage{
plotdiff(model, level2, level1, der = NULL, est.include = FALSE,
  xlab = model$name[2], ylab = model$name[1], ylim = NULL, main = NULL,
  col = "black", CIcol = "black", CIlinecol = "transparent",
  abline = TRUE, ablinecol = "red", lty = 1, CIlty = 2, lwd = 1,
  CIlwd = 1.5, alpha = 0.2, ...)
}
\arguments{
\item{model}{Parametric or nonparametric regression out 
obtained by \code{\link{frfast}} function.}

\item{level2}{Second factor's level at which to perform the 
differences between curves.}

\item{level1}{First factor's level at which to perform the 
differences between curves.}

\item{der}{Number or vector which determines any inference process. 
By default \code{der} is \code{NULL}. If this term is \code{0}, the plot 
shows the differences between estimated regression functions. If it is 
\code{1} or \code{2}, it is designed for the first or second derivative, 
respectively.}

\item{est.include}{Draws the estimates of the model. 
By default it is \code{FALSE}.}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{ylim}{The \code{y} limits of the plot.}

\item{main}{An overall title for the plot.}

\item{col}{A specification for the default plotting color.}

\item{CIcol}{A specification for the default confidence intervals
plotting color.}

\item{CIlinecol}{A specification for the default confidence intervals
plotting color (for the edge).}

\item{abline}{Draw an horizontal line into the plot of the second derivative 
of the model.}

\item{ablinecol}{The color to be used for \code{abline}.}

\item{lty}{The line type. Line types can either be specified as an integer
(0 = blank, 1 = solid (default), 2 = dashed, 3 = dotted, 4 = dotdash, 
5 = longdash, 6 = twodash).  See details in \code{\link{par}}.}

\item{CIlty}{The line type for confidence intervals. Line types can either 
be specified as an integer (0 = blank, 1 = solid (default), 2 = dashed,
3 = dotted, 4 = dotdash, 5 = longdash, 6 = twodash).}

\item{lwd}{The line width, a positive number, defaulting to 1.
See details in \code{\link{par}}.}

\item{CIlwd}{The line width for confidence intervals, a positive number, 
defaulting to 1.}

\item{alpha}{Alpha transparency for overlapping elements expressed 
as a fraction between 0 (complete transparency) and 1 (complete opacity).}

\item{\ldots}{Other options.}
}
\value{
Simply produce a plot.
}
\description{
Useful for drawing the differences between the estimation of 
curves (initial estimate, first or second derivative) for  two factor's levels.
Missing values of factor's levels is not allowed.
}
\examples{
library(npregfast)
data(barnacle)

# Nonparametric regression with interactions
fit2 <- frfast(DW ~ RC : F, data = barnacle, nboot = 100) 
plotdiff(fit2, level2 = "lens", level1 = "barca")
plotdiff(fit2, level2 = "lens", level1 = "barca", der = 1, col = "blue", CIcol = "grey")
plotdiff(fit2, "lens", "barca", der = c(0, 1), ylim = c(-0.05, 0.05))



}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}

