% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalties.R
\name{sic.penalty}
\alias{sic.penalty}
\title{Schwarz Information Criterion penalty}
\usage{
sic.penalty(n, n.param, alpha = 1, ...)
}
\arguments{
\item{n}{The number of observations.}

\item{n.param}{The number of parameters in the model for which the penalty is evaluated.}

\item{alpha}{A scalar greater or equal than one.}

\item{...}{Not in use.}
}
\value{
the penalty term \eqn{\code{n.param}\times(\log(n))^{\code{alpha}}}{n.param * (log(n))^(alpha)}.
}
\description{
The function evaluates the penalty term for Schwarz Information Criterion. 
If \code{alpha} is greater than 1,  the strengthen SIC proposed proposed in Fryzlewicz (2014) is calculated. This routine is typically not called directly by the user; 
its name can be passed as an argument to \code{\link{features}}.
}
\examples{
#*** a simple example how to use the AIC penalty
x <- rnorm(300) + c(rep(1,50),rep(0,250))
w <- not(x)
w.cpt <- features(w, penalty="sic")
w.cpt$cpt[[1]]
}
\references{
R. Baranowski, Y. Chen, and P. Fryzlewicz (2016). Narrowest-Over-Threshold Change-Point Detection.  (\url{http://personal.lse.ac.uk/baranows/not/not.pdf})

P. Fryzlewicz (2014). Wild Binary Segmentation for multiple change-point detection. Annals of Statistics. (\url{http://stats.lse.ac.uk/fryzlewicz/wbs/wbs.pdf})
}

