% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{split}
\alias{split}
\alias{split,CompositionMatrix-method}
\alias{split,LogRatio-method}
\title{Divide into Groups}
\usage{
\S4method{split}{CompositionMatrix}(x, f, drop = FALSE, ...)

\S4method{split}{LogRatio}(x, f, drop = FALSE, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{f}{A 'factor' in the sense that \code{\link[=as.factor]{as.factor(f)}} defines
the grouping, or a list of such factors in which case their interaction is
used for the grouping (see \code{\link[base:split]{base::split()}}).}

\item{drop}{A \code{\link{logical}} scalar: should levels that do not occur be dropped?}

\item{...}{Currently not used.}
}
\value{
A \code{list} of \code{\linkS4class{CompositionMatrix}} objects.
}
\description{
Divides the compositional matrix \code{x} into the groups defined by \code{f}.
}
\examples{
## Create a data.frame
X <- data.frame(
  samples = c("A", "A", "A", "B", "B", "B", "C", "C", "C"),
  groups = c("X", "X", "X", "X", NA, NA, "Y", "Y", "Y"),
  Ca = c(7.72, 7.32, 3.11, 7.19, 7.41, 5, 4.18, 1, 4.51),
  Fe = c(6.12, 5.88, 5.12, 6.18, 6.02, 7.14, 5.25, 5.28, 5.72),
  Na = c(0.97, 1.59, 1.25, 0.86, 0.76, 0.51, 0.75, 0.52, 0.56)
)

## Coerce to a compositional matrix
Y <- as_composition(X)

## Split by group
split(Y, f = get_groups(Y))

## Split by sample
split(Y, f = get_samples(Y))
}
\seealso{
Other mutators: 
\code{\link{groups}},
\code{\link{identifiers}},
\code{\link{samples}},
\code{\link{subset}()},
\code{\link{totals}}
}
\author{
N. Frerebeau
}
\concept{mutators}
