% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consClustResTable.R
\name{consClustResTable}
\alias{consClustResTable}
\title{Consensus Cluster Results in a Table}
\usage{
consClustResTable(neatmap_res)
}
\arguments{
\item{neatmap_res}{Output from the \code{\link{neatmap}} function.}
}
\description{
\code{consClustResTable} presents a table of the consensus cluster results.
The table presents the results of each iteration of the 
\code{\link[ConsensusClusterPlus]{ConsensusClusterPlus}} algorithm, the
cluster consensus of each cluster and the list of the cluster elements with
their corresponding item consensus. The item consensus is taken with respect
to the variable's cluster allocation.
}
\examples{
# create the data frame using the network, node and edge attributes
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)

# run the neatmap code on df
neat_res <- neatmap(df, scale_df = "ecdf", max_k = 3, reps = 100, 
                    xlab = "vars", ylab = "nets", xlab_cex = 1, ylab_cex = 1)

# get the consensus cluster results for each iteration
consensus_res_df <- consClustResTable(neat_res)
}
\references{
For more information on the consensus cluster and item consensus
statistics, see
\href{https://link.springer.com/article/10.1023\%2FA\%3A1023949509487}{Monti et al.}.
}
\author{
Philippe Boileau , \email{philippe_boileau@berkeley.edu}
}
