% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_ranges.R
\name{partition_ranges}
\alias{partition_ranges}
\title{Split ranges into multiple records}
\usage{
partition_ranges(df, start_var, end_var, fmt = "\%Y-\%m-\%d",
  vars_to_keep = NULL, partition_by = "year")
}
\arguments{
\item{df}{Your data frame (can also be a data.table or a tibble)}

\item{start_var}{Start variable}

\item{end_var}{End variable}

\item{fmt}{Format of the date; defaults to Y-m-d}

\item{vars_to_keep}{Any column you'd like to retain (optional)}

\item{partition_by}{How should the range be partitioned ('year' or 'month'); defaults to 'year'}
}
\value{
Returns a data frame with start, end and optional grouping columns
}
\description{
Split ranges into multiple records
}
\examples{

df <- data.frame(group = c("a", "a", "b", "b", "c"),
start = c("2017-05-01", "2019-04-03", "2011-03-03", "2014-05-07", "2017-02-01"),
end = c("2018-09-01", "2020-04-03", "2012-05-03", "2016-04-02", "2017-04-05")
) 

partition_ranges(df, "start", "end", partition_by = "month")
}
