% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_variants.R
\name{expand_dates}
\alias{expand_dates}
\title{Expand date ranges.}
\usage{
expand_dates(df, start_var, end_var, name = "Expanded",
  fmt = "\%Y-\%m-\%d", vars_to_keep = NULL, unit = "day")
}
\arguments{
\item{df}{Data frame (can also be a data.table or a tibble)}

\item{start_var}{Start Date column}

\item{end_var}{End Date column}

\item{name}{The name of newly created column. Defaults to 'Expanded'}

\item{fmt}{The format of date columns, defaults to Y-M-D}

\item{vars_to_keep}{Which columns you would like to keep}

\item{unit}{By which unit of time you want to expand; the default is day}
}
\value{
Returns a full data frame with expanded sequences in a column, e.g. by day or month.
}
\description{
Expand date ranges.
}
\examples{

df <- data.frame(
id = c("1111", "2222", "3333"),
gender = c("M", "F", "F"),
start = c("2018-01-01", "2019-01-01", "2020-01-01"),
end = c("2018-01-05", "2019-01-07", "2020-01-08")
)

expand_dates(df, start_var = "start", end_var = "end", 
vars_to_keep = c("id", "gender"), unit = "day")

}
