\name{ndlStatistics}
\alias{ndlStatistics}
\title{
  Calculate goodness of fit statistics for a naive discriminative
  learning model.
}
\description{
  \code{ndlStatistics} takes an Naive Discriminary Learning model
  object as generated by \code{\link{ndlClassify}} and calculates a
  range of goodness of fit statistics using
  \code{\link{modelStatistics}}.
}
\usage{
ndlStatistics(ndl, \dots)
}
\arguments{
  \item{ndl}{
    A naive discriminative learning model fitted with \code{\link{ndlClassify}}.
  }
  \item{\dots}{
    Control arguments to be passed along to \code{modelStatistics}.
  }
}
\value{
  A list with the following components:
  \describe{
    \item{\code{n.data}}{sum frequency of data points}
    \item{\code{df.null}}{degrees of freedom of the Null model}
    \item{\code{df.model}}{degrees of freedom of the fitted model}
    \item{\code{statistics}}{a list of various measures of goodness of fit calculated with \code{modelStatistics}}
  }
}
\references{
  Arppe, A. and Baayen, R. H. (in prep.) Statistical modeling and the
  principles of human learning.
}
\author{
Antti Arppe and Harald Baayen
}
\seealso{
See also \code{\link{ndlClassify}}, \code{\link{modelStatistics}}.
}
\examples{
data(think)
set.seed(314)
think <- think[sample(1:nrow(think),500),]
think.ndl <- ndlClassify(Lexeme ~ Agent + Patient, data=think)
ndlStatistics(think.ndl)

\dontrun{
data(dative)
dative.ndl <- ndlClassify(RealizationOfRecipient ~ AnimacyOfRec + DefinOfRec +
   PronomOfRec + AnimacyOfTheme + DefinOfTheme + PronomOfTheme, data=dative)
ndlStatistics(dative.ndl)
}
}
\keyword{ discriminative learning }
