% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-mfdr.R
\name{local_mfdr}
\alias{local_mfdr}
\title{Estimate local mFDR for all features}
\usage{
local_mfdr(fit, lambda, X = NULL, y = NULL, method = c("ashr", "kernel"), ...)
}
\arguments{
\item{fit}{A fitted \code{ncvreg} or \code{ncvsurv} object.}

\item{lambda}{The value of lambda at which inference should be carried out.}

\item{X, y}{The design matrix and response used to fit the model; in most cases, it is not necessary to provide
\code{X} and \code{y} as they are returned by \code{ncvreg}, but see the \code{returnX} argument in \code{\link[=ncvreg]{ncvreg()}}.}

\item{method}{What method should be used to calculate the local fdr?  Options are \code{ashr} (which tends to be more
accurate) and \code{kernel} (which requires no additional packages).  The default is to use \code{ashr} if the package is
installed.}

\item{...}{Additional arguments to \code{ash()} if using \code{method='ashr'}.}
}
\value{
If all features are penalized, then the object returns a data frame with one row per feature and four columns:
\itemize{
\item \code{Estimate}: The coefficient estimate from the penalized regression fit
\item \code{z}: A test statistic that approximately follows a standard normal distribution under the null hypothesis that the
feature is marginally independent of the outcome
\item \code{mfdr}: The estimated marginal local false discovery rate
\item \code{Selected}: Features with nonzero coefficient estimates are given an asterisk
}

If some features are penalized and others are not, then a list is returned with two elements: \code{pen.vars}, which consists
of the data frame described above, and \code{unpen.vars}, a data frame with four columns: \code{Estimate}, \code{SE}, \code{Statistic}, and
\code{p.value}.  The standard errors and p-values are based on a classical \code{lm}/\code{glm}/\code{coxph} model using the effect of the
penalized features as an offset.
}
\description{
\code{local_mfdr()} is called by \code{summary.ncvreg()}, which typically offers a more convenient interface to users.
If, however, you are working with local mfdrs programmatically rather than interactively, you probably want to
use \code{local_mfdr()}, which skips the sorting, filtering, and print formatting of \code{summary.ncvreg()}.
}
\examples{
# Linear regression
data(Prostate)
fit <- ncvreg(Prostate$X, Prostate$y)
local_mfdr(fit, 0.1)

fit <- ncvreg(Prostate$X, Prostate$y, penalty.factor=rep(0:1, each=4))
local_mfdr(fit, 0.1)

# Logistic regression
data(Heart)
X <- Heart$X
y <- Heart$y
fit <- ncvreg(X, y, family='binomial')
local_mfdr(fit, 0.1)

# Cox regression
data(Lung)
X <- Lung$X
y <- Lung$y
fit <- ncvsurv(X, y)
local_mfdr(fit, 0.1)
}
\seealso{
\code{\link[=summary.ncvreg]{summary.ncvreg()}}
}
