\name{nc.put.var.subset.by.axes}
\alias{nc.put.var.subset.by.axes}
\title{Puts a data subset in the place described by the named list of axes}
\usage{
nc.put.var.subset.by.axes(f, v, dat, axis.indices, axes.map = NULL,
  input.axes = NULL)
}
\arguments{
  \item{f}{An object of class \code{ncdf4} which represents
  a NetCDF file.}

  \item{v}{A string naming a variable in a file or an
  object of class \code{ncvar4}.}

  \item{dat}{The data to put in the file.}

  \item{axis.indices}{A list consisting of zero or more
  vectors of indices, named by which axis they refer to (X,
  Y, T, etc).}

  \item{axes.map}{An optional vector mapping axes to NetCDF
  dimensions. If not supplied, it will be generated from
  the file.}

  \item{input.axes}{An optional vector containing the input
  axis map. If supplied, it will be used to permute the
  data from the axis order in the input data, to the axis
  order in the output data.}
}
\description{
Puts a data subset in the place described by the named list
of axes.
}
\details{
This function will write data (\code{dat}) out to the
specified file (\code{f}) and variable (\code{v}) at the
location specified by \code{axis.indices}.
}
\examples{
## Copy a subset of the data from one location to another.
\dontrun{
f <- nc_open("pr.nc")
dat <- nc.get.var.subset.by.axes(f1, "pr", list(X=1:4, Y=c(1, 3, 5)))
nc.put.var.subset.by.axes(f1, "pr", dat, list(X=5:8, Y=1:3))
nc_close(f)
}
}
\seealso{
\code{\link{ncdf4.helpers-package}}
}

