% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{neuronlist-dataframe-methods}
\alias{neuronlist-dataframe-methods}
\alias{[.neuronlist}
\alias{[<-.neuronlist}
\alias{droplevels.neuronlist}
\alias{droplevels}
\alias{with.neuronlist}
\alias{with}
\alias{head.neuronlist}
\alias{head}
\alias{tail.neuronlist}
\alias{tail}
\title{Methods for working with the dataframe attached to a neuronlist}
\usage{
\method{[}{neuronlist}(x, i, j, drop)

\method{[}{neuronlist}(x, i, j) <- value

\method{droplevels}{neuronlist}(x, except = NULL, ...)

\method{with}{neuronlist}(data, expr, ...)

\method{head}{neuronlist}(x, ...)

\method{tail}{neuronlist}(x, ...)
}
\arguments{
\item{x}{A neuronlist object}

\item{i, j}{elements to extract or replace. Numeric or character or, for [ 
only, empty. Numeric values are coerced to integer as if by 
\code{as.integer}. See \code{\link{[.data.frame}} for details.}

\item{drop}{logical.  If \code{TRUE} the result is coerced to the
    lowest possible dimension.  The default is to drop if only one
    column is left, but \bold{not} to drop if only one row is left.}

\item{value}{A suitable replacement value: it will be repeated a whole
    number of times if necessary and it may be coerced: see the
    Coercion section.  If \code{NULL}, deletes the column if a single
    column is selected.}

\item{except}{indices of columns from which \emph{not} to drop levels}

\item{...}{Further arguments passed to default methods (and usually ignored)}

\item{data}{A neuronlist object}

\item{expr}{The expression to evaluate}
}
\value{
the attached dataframe with levels dropped (NB \strong{not} the
  neuronlist)
}
\description{
\code{[.neuronlist} and \code{[<-.neuronlist} behave like the 
  corresponding base methods (\code{[.data.frame}, \code{[<-.data.frame}) 
  allowing extraction or replacement of parts of the data.frame attached to
  the neuronlist.

\code{droplevels} Remove redundant factor levels in dataframe 
  attached to neuronlist

\code{with} Evaluate expression in the context of dataframe
  attached to a neuronlist

\code{head} Return the first part of data.frame attached to
  neuronlist

\code{tail} Return the last part of data.frame attached to 
  neuronlist
}
\examples{
## treat kcs20 as data.frame
kcs20[1, ]
kcs20[1:3, ]
kcs20[, 1:4]
kcs20[, 'soma_side']
# alternative to as.data.frame(kcs20)
kcs20[, ]

## can also set columns
kcs13=kcs20[1:3]
kcs13[,'side']=as.character(kcs13[,'soma_side'])
head(kcs13)
# or parts of columns
kcs13[1,'soma_side']='R'
kcs13['FruMARCM-M001205_seg002','soma_side']='L'
# remove a column
kcs13[,'side']=NULL
all.equal(kcs13, kcs20[1:3])

# can even replace the whole data.frame like this
kcs13[,]=kcs13[,]
all.equal(kcs13, kcs20[1:3])

## get row/column names of attached data.frame 
# (unfortunately implementing ncol/nrow is challenging)
rownames(kcs20)
colnames(kcs20)
}
\seealso{
\code{\link{[.data.frame}}, @seealso \code{\link{[<-.data.frame}}

\code{\link{droplevels}}

\code{\link{with}}

\code{\link{head}}

\code{\link{tail}}

Other neuronlist: 
\code{\link{*.neuronlist}()},
\code{\link{is.neuronlist}()},
\code{\link{neuronlistfh}()},
\code{\link{neuronlist}()},
\code{\link{nlapply}()},
\code{\link{read.neurons}()},
\code{\link{write.neurons}()}
}
\concept{neuronlist}
