% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im3d.R
\name{voxdims}
\alias{voxdims}
\alias{voxdims.im3d}
\alias{voxdims.character}
\alias{voxdims.default}
\title{Return voxel dimensions of an object}
\usage{
voxdims(x, ...)

\method{voxdims}{im3d}(x, ...)

\method{voxdims}{character}(x, ...)

\method{voxdims}{default}(x, dims, ...)
}
\arguments{
\item{x}{An \code{im3d} object with associated voxel dimensions, a path to  or a 2 x 3 
BoundingBox \code{matrix}.}

\item{...}{Additional arguments for methods}

\item{dims}{The number of voxels in each dimension when x is a BoundingBox 
matrix.}
}
\value{
A numeric vector of length 3, NA when missing.
}
\description{
This would properly be thought of as the voxel spacing when 
  voxels are assumed not to have a physical extent (only a location).
}
\details{
We follow Amira's convention of returning a voxel dimension equal to
  the bounding box size (rather than 0) for any dimension with only 1 voxel.
}
\seealso{
\code{\link{boundingbox}}

Other im3d: \code{\link{as.im3d}},
  \code{\link{boundingbox}}, \code{\link{im3d-coords}},
  \code{\link{im3d-io}}, \code{\link{im3d}},
  \code{\link{imexpand.grid}}, \code{\link{imslice}},
  \code{\link{is.im3d}}, \code{\link{mask}},
  \code{\link{origin}}, \code{\link{projection}},
  \code{\link{threshold}}, \code{\link{unmask}}
}
\concept{im3d}
