% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgwc.R
\name{fgwcuv}
\alias{fgwcuv}
\title{Classical Fuzzy Geographicaly Weighted Clustering}
\usage{
fgwcuv(
  data,
  pop,
  distmat,
  kind = NA,
  ncluster = 2,
  m = 2,
  distance = "euclidean",
  order = 2,
  alpha = 0.7,
  a = 1,
  b = 1,
  max.iter = 500,
  error = 1e-05,
  randomN = 0,
  uij = NA,
  vi = NA
)
}
\arguments{
\item{data}{an object of data with d>1. Can be \code{matrix} or \code{data.frame}. If your data is univariate, bind it with \code{1} to get a 2 columns.}

\item{pop}{an n*1 vector contains population.}

\item{distmat}{an n*n distance matrix between regions.}

\item{kind}{use \code{'u'} if you want to use membership approach and \code{'v'} for centroid approach.}

\item{ncluster}{an integer. The number of clusters.}

\item{m}{degree of fuzziness or fuzzifier. Default is 2.}

\item{distance}{the distance metric between data and centroid, the default is euclidean, see \code{\link{cdist}} for details.}

\item{order, }{minkowski order. default is 2.}

\item{alpha}{the old membership effect with [0,1], if \code{alpha} equals 1, it will be same as fuzzy C-Means, if 0, it equals to neighborhood effect.}

\item{a}{spatial magnitude of distance. Default is 1.}

\item{b}{spatial magnitude of population. Default is 1.}

\item{max.iter}{maximum iteration. Default is 500.}

\item{error}{error tolerance. Default is 1e-5.}

\item{randomN}{random seed for initialisation (if uij or vi is NA). Default is 0.}

\item{uij}{membership matrix initialisation.}

\item{vi}{centroid matrix initialisation.}
}
\value{
an object of class \code{"fgwc"}.\cr
An \code{"fgwc"} object contains as follows:
\itemize{
\item \code{converg} - the process convergence of objective function
\item \code{f_obj} - objective function value
\item \code{membership} - membership matrix
\item \code{centroid} - centroid matrix
\item \code{validation} - validation indices (there are partition coefficient (\code{PC}), classification entropy (\code{CE}), 
SC index (\code{SC}), separation index (\code{SI}), Xie and Beni's index (\code{XB}), IFV index (\code{IFV}), and Kwon index (Kwon))
\item \code{max.iter} - Maximum iteration
\item \code{cluster} - the cluster of the data
\item \code{finaldata} - The final data (with the cluster)
\item \code{call} - the syntax called previously
\item \code{time} - computational time.
}
}
\description{
Fuzzy clustering with addition of spatial configuration of membership matrix
}
\details{
Fuzzy Geographically Weighted Clustering (FGWC) was developed by \insertCite{fgwc;textual}{naspaclust} by adding 
neighborhood effects and population to configure the membership matrix in Fuzzy C-Means. There are two kinds of options in doing classical FGWC.
The first is using \code{"u"} \insertCite{Runkler2006}{naspaclust} (default) for membership optimization 
and \code{"v"} \insertCite{fgwc}{naspaclust} for centroid optimisation.
}
\examples{
data('census2010')
data('census2010dist')
data('census2010pop')
res1 <- fgwcuv(census2010,census2010pop,census2010dist,'u',3,2,'euclidean',4)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{abcfgwc}} \code{\link{fpafgwc}} \code{\link{gsafgwc}} \code{\link{hhofgwc}} \code{\link{ifafgwc}} \code{\link{psofgwc}} \code{\link{tlbofgwc}}
}
