% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{get_driver_info}
\alias{get_driver_info}
\title{Enhanced Get Driver Info with Smart Matching}
\usage{
get_driver_info(driver, series = "all", type = "summary", interactive = TRUE)
}
\arguments{
\item{driver}{Character string of driver name to search for}

\item{series}{Either character string ("cup", "xfinity", "truck", "all") or data frame}

\item{type}{Character string specifying return type ("summary", "season", "all")}

\item{interactive}{Logical. Is the session interactive?}
}
\value{
Tibble with driver statistics or NULL if no exact match
}
\description{
Enhanced Get Driver Info with Smart Matching
}
\examples{
\dontrun{
# Get Christopher Bell's career summary
get_driver_info("Christopher Bell")

# Handle misspelling - will prompt for selection
get_driver_info("cristopher bell")
# Found 1 drivers matching 'cristopher bell':
#  1 - Christopher Bell
# Select driver number: 1
# Driver: Christopher Bell
# Returns summary table

# Get season-by-season data for Cup series only
get_driver_info("Christopher Bell", series = "cup", type = "season")
}
}
