% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasapower-package.R
\docType{package}
\name{nasapower-package}
\alias{nasapower}
\alias{nasapower-package}
\title{nasapower: NASA POWER API Client}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Client for 'NASA' 'POWER' global meteorology, surface solar
    energy and climatology data 'API'.  'POWER' (Prediction Of Worldwide Energy 
    Resource) data are freely available for download with a spatial resolution 
    of 0.5 x 0.625 degree latitude and longitude for meteorology and  1 x 1
    degree latitude and longitude for solar parameters with various temporal
    resolutions depending on the POWER parameter and community.  This work is
    funded through the 'NASA' Earth Science Directorate Applied Science Program.
    For more on the data themselves, the methodologies used in creating, a web-
    based data viewer and web access, please see <https://power.larc.nasa.gov/>.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/nasapower/}
  \item Report bugs at \url{https://github.com/ropensci/nasapower/issues}
}

}
\author{
\strong{Maintainer}: Adam H. Sparks \email{adamhsparks@gmail.com} (\href{https://orcid.org/0000-0002-0061-8359}{ORCID})

Other contributors:
\itemize{
  \item Scott Chamberlain \email{myrmecocystus@gmail.com} (\href{https://orcid.org/0000-0003-1444-9135}{ORCID}) (Scott Chamberlain reviewed nasapower for rOpenSci, see
                        https://github.com/ropensci/software-review/issues/155) [reviewer]
  \item Hazel Kavili (Hazel Kavili reviewed nasapower for rOpenSci, see
            https://github.com/ropensci/software-review/issues/155) [reviewer]
  \item Alison Boyer (Alison Boyer reviewed nasapower for rOpenSci, see
            https://github.com/ropensci/software-review/issues/155) [reviewer]
  \item Fernando Miguez (\href{https://orcid.org/0000-0002-4627-8329}{ORCID}) (Fernando Miguez provided assistance in identifying
                        improper missing value handling in the POWER data, see 
                        <https://github.com/femiguez/apsimx/pull/26>) [contributor]
}

}
\keyword{internal}
