% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{.context}
\alias{.context}
\title{Technical Utility: Open Context}
\usage{
.context(socket)
}
\arguments{
\item{socket}{a Socket.}
}
\value{
An external pointer.
}
\description{
Open a new Context to be used with a Socket. This function is a performance
    variant of \code{\link{context}}, designed to wrap a socket in a function
    argument when calling \code{\link{request}} or \code{\link{reply}}.
}
\details{
External pointers created by this function are unclassed, hence
    methods for contexts such as \code{\link{close}} will not work. However
    they function as a Context would when passed to all messaging functions.
    The context is automatically closed when the object is garbage collected.
}
\examples{
s <- socket("req", listen = "inproc://nanonext")
r <- request(.context(s), "request data")
close(s)

}
